/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.potion;

import com.hollingsworth.arsnouveau.api.potion.IPotionProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionData
implements Cloneable {
    private Potion potion = Potions.f_43598_;
    private List<MobEffectInstance> customEffects = new ArrayList<MobEffectInstance>();
    private Set<Potion> includedPotions = new HashSet<Potion>();

    public PotionData(Potion potion, List<MobEffectInstance> customEffects, Set<Potion> includedPotions) {
        this.potion = potion;
        this.includedPotions = includedPotions;
        this.setCustomEffects(customEffects);
    }

    public PotionData() {
        this(Potions.f_43598_, new ArrayList<MobEffectInstance>(), new HashSet<Potion>());
    }

    public PotionData(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IPotionProvider) {
            IPotionProvider provider = (IPotionProvider)item;
            PotionData data = provider.getPotionData(stack).clone();
            this.potion = data.getPotion();
            this.customEffects = data.getCustomEffects();
        } else {
            this.potion = PotionUtils.m_43579_((ItemStack)stack);
            this.customEffects = new ArrayList<MobEffectInstance>();
            this.setCustomEffects(PotionUtils.m_43571_((ItemStack)stack));
        }
    }

    public PotionData(Potion potion) {
        this(potion, new ArrayList<MobEffectInstance>(), new HashSet<Potion>(Collections.singletonList(potion)));
    }

    public PotionData(PotionData data) {
        this(data.getPotion(), new ArrayList<MobEffectInstance>(data.getCustomEffects()), new HashSet<Potion>(data.getIncludedPotions()));
    }

    public ItemStack asPotionStack() {
        return this.asPotionStack(Items.f_42589_);
    }

    public ItemStack asPotionStack(Item item) {
        ItemStack potionStack = new ItemStack((ItemLike)item);
        if (this.getPotion() == Potions.f_43598_) {
            return potionStack;
        }
        PotionUtils.m_43549_((ItemStack)potionStack, (Potion)this.getPotion());
        PotionUtils.m_43552_((ItemStack)potionStack, this.getCustomEffects());
        return potionStack;
    }

    public static PotionData fromTag(CompoundTag tag) {
        PotionData instance = new PotionData();
        instance.setPotion(PotionUtils.m_43577_((CompoundTag)tag));
        instance.getCustomEffects().addAll(PotionUtils.m_43573_((CompoundTag)tag));
        ListTag potionTagList = tag.m_128437_("includedPotions", 8);
        Set<Potion> potions = instance.includedPotions;
        for (int i = 0; i < potionTagList.size(); ++i) {
            potions.add(Potion.m_43489_((String)potionTagList.m_128778_(i)));
        }
        return instance;
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Potion", ForgeRegistries.POTIONS.getKey((Object)this.getPotion()).toString());
        if (!this.getCustomEffects().isEmpty()) {
            ListTag listnbt = new ListTag();
            for (MobEffectInstance effectinstance : this.getCustomEffects()) {
                listnbt.add((Object)effectinstance.m_19555_(new CompoundTag()));
            }
            tag.m_128365_("CustomPotionEffects", (Tag)listnbt);
        }
        ListTag potionTagList = new ListTag();
        ArrayList<String> potionNames = new ArrayList<String>(this.getIncludedPotions().stream().map(potion -> ForgeRegistries.POTIONS.getKey(potion).toString()).toList());
        for (String potion2 : potionNames) {
            potionTagList.add((Object)StringTag.m_129297_((String)potion2));
        }
        tag.m_128365_("includedPotions", (Tag)potionTagList);
        return tag;
    }

    public List<MobEffectInstance> fullEffects() {
        ArrayList<MobEffectInstance> thisEffects = new ArrayList<MobEffectInstance>(this.getCustomEffects());
        thisEffects.addAll(this.getPotion().m_43488_());
        return thisEffects;
    }

    public void applyEffects(Entity source, Entity inDirectSource, LivingEntity target) {
        for (MobEffectInstance effectinstance : this.fullEffects()) {
            if (effectinstance.m_19544_().m_8093_()) {
                effectinstance.m_19544_().m_19461_(source, inDirectSource, target, effectinstance.m_19564_(), 1.0);
                continue;
            }
            target.m_147207_(new MobEffectInstance(effectinstance), source);
        }
    }

    public boolean areSameEffects(List<MobEffectInstance> effects) {
        List<MobEffectInstance> thisEffects = this.fullEffects();
        if (thisEffects.size() != effects.size()) {
            return false;
        }
        effects.sort(Comparator.comparing(MobEffectInstance::toString));
        thisEffects.sort(Comparator.comparing(MobEffectInstance::toString));
        return thisEffects.equals(effects);
    }

    public boolean isEmpty() {
        return this.getPotion() == Potions.f_43598_ || this.getPotion() == Potions.f_43599_ || this.getPotion() == Potions.f_43600_ || this.fullEffects().isEmpty();
    }

    public boolean areSameEffects(PotionData other) {
        return this.areSameEffects(other.fullEffects());
    }

    public PotionData mergeEffects(PotionData other) {
        if (this.areSameEffects(other)) {
            return new PotionData(this.getPotion(), this.getCustomEffects(), this.getIncludedPotions());
        }
        HashSet<MobEffectInstance> set = new HashSet<MobEffectInstance>();
        set.addAll(this.fullEffects());
        set.addAll(other.fullEffects());
        HashSet<Potion> potions = new HashSet<Potion>();
        potions.addAll(this.getIncludedPotions());
        potions.addAll(other.getIncludedPotions());
        return new PotionData(this.getPotion(), new ArrayList<MobEffectInstance>(set), potions);
    }

    public void appendHoverText(List<Component> tooltip) {
        if (this.getPotion() == Potions.f_43598_) {
            return;
        }
        ItemStack potionStack = this.asPotionStack();
        tooltip.add(potionStack.m_41786_());
        PotionUtils.m_43555_((ItemStack)potionStack, tooltip, (float)1.0f);
    }

    public boolean equals(Object obj) {
        PotionData other;
        return obj instanceof PotionData && this.areSameEffects(other = (PotionData)obj);
    }

    public PotionData clone() {
        try {
            PotionData clone = (PotionData)super.clone();
            clone.setPotion(this.getPotion());
            clone.setCustomEffects(new ArrayList<MobEffectInstance>(this.getCustomEffects()));
            clone.setIncludedPotions(new HashSet<Potion>(this.getIncludedPotions()));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public Potion getPotion() {
        return this.potion;
    }

    public void setPotion(Potion potion) {
        this.potion = potion;
    }

    public List<MobEffectInstance> getCustomEffects() {
        return this.customEffects;
    }

    public void setCustomEffects(List<MobEffectInstance> customEffects) {
        this.customEffects = customEffects.stream().filter(e -> !this.potion.m_43488_().contains(e)).collect(Collectors.toList());
    }

    public Set<Potion> getIncludedPotions() {
        this.includedPotions.add(this.getPotion());
        this.includedPotions.removeIf(potion -> potion == Potions.f_43598_);
        return this.includedPotions;
    }

    public void setIncludedPotions(Set<Potion> includedPotions) {
        this.includedPotions = includedPotions;
    }
}

