/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.api.potion.PotionData;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.PotionStoreGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.PotionTakeGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyListBehavior;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class StarbyPotionBehavior
extends StarbyListBehavior {
    public static final ResourceLocation POTION_ID = new ResourceLocation("ars_nouveau", "starby_potion");
    @Nullable
    private PotionData heldPotion = null;
    private int amount;

    public StarbyPotionBehavior(Starbuncle entity, CompoundTag tag) {
        super(entity, tag);
        this.heldPotion = PotionData.fromTag(tag.m_128469_("potionData"));
        this.amount = tag.m_128451_("amount");
        this.goals.add(new WrappedGoal(3, (Goal)new PotionTakeGoal(entity, this)));
        this.goals.add(new WrappedGoal(3, (Goal)new PotionStoreGoal(entity, this)));
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionFirst(storedPos, face, storedEntity, playerEntity);
        if (storedPos != null && this.level.m_7702_(storedPos) instanceof PotionJarTile) {
            this.addToPos(storedPos);
            this.syncTag();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.starbuncle.potion_to"));
        }
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionLast(storedPos, face, storedEntity, playerEntity);
        if (storedPos != null && this.level.m_7702_(storedPos) instanceof PotionJarTile) {
            this.addFromPos(storedPos);
            this.syncTag();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.starbuncle.potion_from"));
        }
    }

    @Nullable
    public BlockPos getJarForTake() {
        for (BlockPos pos : this.FROM_LIST) {
            if (!this.isPositionValidTake(pos)) continue;
            return pos;
        }
        return null;
    }

    public boolean isPositionValidTake(BlockPos p) {
        if (p == null) {
            return false;
        }
        BlockEntity blockEntity = this.level.m_7702_(p);
        if (blockEntity instanceof PotionJarTile) {
            PotionJarTile jar = (PotionJarTile)blockEntity;
            return jar.getAmount() >= 100 && this.getJarForStorage(jar.getData()) != null;
        }
        return false;
    }

    @Nullable
    public BlockPos getJarForStorage(PotionData data) {
        for (BlockPos pos : this.TO_LIST) {
            if (!(this.level.m_7702_(pos) instanceof PotionJarTile) || !this.isPositionValidStore(pos, data)) continue;
            return pos;
        }
        return null;
    }

    public boolean isPositionValidStore(BlockPos p, PotionData data) {
        PotionJarTile jar;
        if (p == null || data == null) {
            return false;
        }
        BlockEntity blockEntity = this.level.m_7702_(p);
        return blockEntity instanceof PotionJarTile && (jar = (PotionJarTile)blockEntity).canAccept(data, 100);
    }

    public PotionData getHeldPotion() {
        return this.heldPotion == null ? new PotionData() : this.heldPotion;
    }

    public void setHeldPotion(PotionData data) {
        this.heldPotion = data;
        this.syncTag();
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        super.getTooltip(tooltip);
        tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.starbuncle.storing_potions", (Object[])new Object[]{this.TO_LIST.size()}));
        tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.starbuncle.taking_potions", (Object[])new Object[]{this.FROM_LIST.size()}));
    }

    @Override
    public CompoundTag toTag(CompoundTag tag) {
        if (this.heldPotion != null) {
            tag.m_128365_("potionData", (Tag)this.heldPotion.toTag());
        }
        tag.m_128405_("amount", this.amount);
        return super.toTag(tag);
    }

    @Override
    public ItemStack getStackForRender() {
        if (this.heldPotion != null && this.heldPotion.getPotion() != Potions.f_43598_) {
            return this.heldPotion.asPotionStack();
        }
        return super.getStackForRender();
    }

    @Override
    protected ResourceLocation getRegistryName() {
        return POTION_ID;
    }
}

