/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OnlyIn(value=Dist.CLIENT)
public class GuidebookStructureCommands {
    private static final Logger LOG = LoggerFactory.getLogger(GuidebookStructureCommands.class);
    @Nullable
    private static String lastOpenedOrSavedPath;
    private static final String[] FILE_PATTERNS;
    private static final String FILE_PATTERN_DESC = "Structure NBT Files (*.snbt, *.nbt)";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder rootCommand = LiteralArgumentBuilder.literal((String)"ae2guide");
        GuidebookStructureCommands.registerImportCommand((LiteralArgumentBuilder<CommandSourceStack>)rootCommand);
        GuidebookStructureCommands.registerExportCommand((LiteralArgumentBuilder<CommandSourceStack>)rootCommand);
        dispatcher.register(rootCommand);
    }

    private static void registerImportCommand(LiteralArgumentBuilder<CommandSourceStack> rootCommand) {
        LiteralArgumentBuilder importSubcommand = LiteralArgumentBuilder.literal((String)"importstructure");
        importSubcommand.requires(source -> Minecraft.m_91087_().m_91091_());
        importSubcommand.then(Commands.m_82129_((String)"origin", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> {
            BlockPos origin = BlockPosArgument.m_264582_((CommandContext)context, (String)"origin");
            GuidebookStructureCommands.importStructure(((CommandSourceStack)context.getSource()).m_81372_(), origin);
            return 0;
        }));
        rootCommand.then((ArgumentBuilder)importSubcommand);
    }

    private static void importStructure(ServerLevel level, BlockPos origin) {
        Minecraft minecraft = Minecraft.m_91087_();
        IntegratedServer server = minecraft.m_91092_();
        LocalPlayer player = minecraft.f_91074_;
        if (server == null || player == null) {
            return;
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(GuidebookStructureCommands::pickFileForOpen, (Executor)minecraft).thenApplyAsync(selectedPath -> {
            if (selectedPath == null) {
                return null;
            }
            lastOpenedOrSavedPath = selectedPath;
            StructureTemplateManager manager = server.m_236738_();
            try {
                CompoundTag compound;
                if (selectedPath.toLowerCase(Locale.ROOT).endsWith(".snbt")) {
                    String textInFile = Files.readString(Paths.get(selectedPath, new String[0]), StandardCharsets.UTF_8);
                    try {
                        compound = NbtUtils.m_178024_((String)textInFile);
                    }
                    catch (CommandSyntaxException e) {
                        LOG.error("Failed to parse structure.", (Throwable)e);
                        player.m_213846_((Component)Component.m_237113_((String)e.toString()));
                        return null;
                    }
                }
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream((String)selectedPath));){
                    compound = NbtIo.m_128939_((InputStream)is);
                }
                StructureTemplate structure = manager.m_230404_(compound);
                if (!structure.m_230328_((ServerLevelAccessor)level, origin, origin, new StructurePlaceSettings(), (RandomSource)new SingleThreadedRandomSource(0L), 2)) {
                    player.m_213846_((Component)Component.m_237113_((String)"Failed to place structure"));
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)"Placed structure"));
                }
            }
            catch (Exception e) {
                LOG.error("Failed to place structure.", (Throwable)e);
                player.m_213846_((Component)Component.m_237113_((String)e.toString()));
            }
            return null;
        }, (Executor)server)).thenRunAsync(() -> {
            if (minecraft.f_91080_ instanceof PauseScreen) {
                minecraft.m_91152_(null);
            }
        }, (Executor)minecraft);
    }

    private static void registerExportCommand(LiteralArgumentBuilder<CommandSourceStack> rootCommand) {
        LiteralArgumentBuilder exportSubcommand = LiteralArgumentBuilder.literal((String)"exportstructure");
        exportSubcommand.requires(source -> Minecraft.m_91087_().m_91091_());
        exportSubcommand.then(Commands.m_82129_((String)"origin", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"sizeX", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"sizeY", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"sizeZ", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            BlockPos origin = BlockPosArgument.m_264582_((CommandContext)context, (String)"origin");
            int sizeX = IntegerArgumentType.getInteger((CommandContext)context, (String)"sizeX");
            int sizeY = IntegerArgumentType.getInteger((CommandContext)context, (String)"sizeY");
            int sizeZ = IntegerArgumentType.getInteger((CommandContext)context, (String)"sizeZ");
            Vec3i size = new Vec3i(sizeX, sizeY, sizeZ);
            GuidebookStructureCommands.exportStructure(((CommandSourceStack)context.getSource()).m_81372_(), origin, size);
            return 0;
        })))));
        rootCommand.then((ArgumentBuilder)exportSubcommand);
    }

    private static void exportStructure(ServerLevel level, BlockPos origin, Vec3i size) {
        Minecraft minecraft = Minecraft.m_91087_();
        IntegratedServer server = minecraft.m_91092_();
        LocalPlayer player = minecraft.f_91074_;
        if (server == null || player == null) {
            return;
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(GuidebookStructureCommands::pickFileForSave, (Executor)minecraft).thenApplyAsync(selectedPath -> {
            if (selectedPath == null) {
                return null;
            }
            try {
                BlockPos to = BlockPos.m_121990_((BlockPos)origin, (BlockPos)origin.m_7918_(size.m_123341_() - 1, size.m_123342_() - 1, size.m_123343_() - 1)).filter(pos -> !level.m_8055_(pos).m_60795_()).reduce(origin, (blockPos, blockPos2) -> new BlockPos(Math.max(blockPos.m_123341_(), blockPos2.m_123341_()), Math.max(blockPos.m_123342_(), blockPos2.m_123342_()), Math.max(blockPos.m_123343_(), blockPos2.m_123343_())));
                BlockPos actualSize = new BlockPos(1 + to.m_123341_() - origin.m_123341_(), 1 + to.m_123342_() - origin.m_123342_(), 1 + to.m_123343_() - origin.m_123343_());
                StructureTemplate structureTemplate = new StructureTemplate();
                structureTemplate.m_163802_((Level)level, origin, (Vec3i)actualSize, false, Blocks.f_50016_);
                CompoundTag compound = structureTemplate.m_74618_(new CompoundTag());
                if (selectedPath.toLowerCase(Locale.ROOT).endsWith(".snbt")) {
                    Files.writeString(Paths.get(selectedPath, new String[0]), (CharSequence)NbtUtils.m_178063_((CompoundTag)compound), StandardCharsets.UTF_8, new OpenOption[0]);
                } else {
                    NbtIo.m_128944_((CompoundTag)compound, (File)new File((String)selectedPath));
                }
                player.m_213846_((Component)Component.m_237113_((String)"Saved structure"));
            }
            catch (IOException e) {
                LOG.error("Failed to save structure.", (Throwable)e);
                player.m_213846_((Component)Component.m_237113_((String)e.toString()));
            }
            return null;
        }, (Executor)server)).thenRunAsync(() -> {
            if (minecraft.f_91080_ instanceof PauseScreen) {
                minecraft.m_91152_(null);
            }
        }, (Executor)minecraft);
    }

    private static String pickFileForOpen() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            String string = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)"Load Structure", (CharSequence)lastOpenedOrSavedPath, (PointerBuffer)GuidebookStructureCommands.createFilterPatterns(stack), (CharSequence)FILE_PATTERN_DESC, (boolean)false);
            return string;
        }
    }

    private static String pickFileForSave() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            String string = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)"Save Structure", (CharSequence)lastOpenedOrSavedPath, (PointerBuffer)GuidebookStructureCommands.createFilterPatterns(stack), (CharSequence)FILE_PATTERN_DESC);
            return string;
        }
    }

    private static PointerBuffer createFilterPatterns(MemoryStack stack) {
        PointerBuffer filterPatternsBuffer = stack.mallocPointer(FILE_PATTERNS.length);
        for (String pattern : FILE_PATTERNS) {
            filterPatternsBuffer.put(stack.UTF8((CharSequence)pattern));
        }
        filterPatternsBuffer.flip();
        return filterPatternsBuffer;
    }

    static {
        FILE_PATTERNS = new String[]{"*.snbt", "*.nbt"};
    }
}

