/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.hotkey;

import appeng.client.guidebook.GuidebookText;
import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.indices.ItemIndex;
import appeng.client.guidebook.screen.GuideScreen;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.AppEngClient;
import com.google.common.base.Strings;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenGuideHotkey {
    private static final KeyMapping OPEN_GUIDE_MAPPING = new KeyMapping("key.ae2.guide", 71, "key.ae2.category");
    private static final Logger LOG;
    private static final int TICKS_TO_OPEN = 10;
    private static final ResourceLocation TOOLTIP_PHASE;
    private static boolean newTick;
    private static ResourceLocation previousItemId;
    @Nullable
    private static PageAnchor guidebookPage;
    private static int ticksKeyHeld;
    private static boolean holding;

    private OpenGuideHotkey() {
    }

    public static void init() {
        if (AEConfig.instance().isGuideHotkeyEnabled()) {
            MinecraftForge.EVENT_BUS.addListener(evt -> OpenGuideHotkey.handleTooltip(evt.getItemStack(), evt.getFlags(), evt.getToolTip()));
            MinecraftForge.EVENT_BUS.addListener(evt -> {
                newTick = true;
            });
        } else {
            LOG.info("AE2 guide hotkey is disabled via config.");
        }
    }

    private static void handleTooltip(ItemStack itemStack, TooltipFlag tooltipFlag, List<Component> lines) {
        GuideScreen guideScreen;
        if (!OpenGuideHotkey.isKeyBound()) {
            holding = false;
            ticksKeyHeld = 0;
            return;
        }
        if (newTick) {
            newTick = false;
            OpenGuideHotkey.update(itemStack);
        }
        if (guidebookPage == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen instanceof GuideScreen && (guideScreen = (GuideScreen)screen).getCurrentPageId().equals((Object)guidebookPage.pageId())) {
            return;
        }
        float progress = ticksKeyHeld;
        progress = holding ? (progress += minecraft.m_91296_()) : (progress -= minecraft.m_91296_());
        Component component = OpenGuideHotkey.makeProgressBar(Mth.m_14036_((float)(progress /= 10.0f), (float)0.0f, (float)1.0f));
        if (lines.isEmpty()) {
            lines.add(component);
        } else {
            lines.add(1, component);
        }
    }

    private static Component makeProgressBar(float progress) {
        Minecraft minecraft = Minecraft.m_91087_();
        MutableComponent holdW = GuidebookText.HoldToShow.text(OpenGuideHotkey.getHotkey().m_90863_().m_6881_().m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY);
        Font fontRenderer = minecraft.f_91062_;
        int charWidth = fontRenderer.m_92895_("|");
        int tipWidth = fontRenderer.m_92852_((FormattedText)holdW);
        int total = tipWidth / charWidth;
        int current = (int)(progress * (float)total);
        if (progress > 0.0f) {
            MutableComponent result = Component.m_237113_((String)Strings.repeat((String)"|", (int)current)).m_130940_(ChatFormatting.GRAY);
            if (progress < 1.0f) {
                result = result.m_7220_((Component)Component.m_237113_((String)Strings.repeat((String)"|", (int)(total - current))).m_130940_(ChatFormatting.DARK_GRAY));
            }
            return result;
        }
        return holdW;
    }

    private static void update(ItemStack itemStack) {
        ResourceLocation itemId = itemStack.m_220173_().m_203543_().map(ResourceKey::m_135782_).orElse(null);
        if (!Objects.equals(itemId, previousItemId)) {
            previousItemId = itemId;
            guidebookPage = null;
            ticksKeyHeld = 0;
            if (itemId == null) {
                return;
            }
            ItemIndex itemIndex = AppEngClient.instance().getGuide().getIndex(ItemIndex.class);
            guidebookPage = (PageAnchor)itemIndex.get(itemId);
        }
        if (holding = OpenGuideHotkey.isKeyHeld()) {
            if (ticksKeyHeld < 10 && ++ticksKeyHeld == 10) {
                if (guidebookPage != null) {
                    Screen screen = Minecraft.m_91087_().f_91080_;
                    if (screen instanceof GuideScreen) {
                        GuideScreen guideScreen = (GuideScreen)screen;
                        guideScreen.navigateTo(guidebookPage);
                    } else {
                        AppEngClient.instance().openGuideAtAnchor(guidebookPage);
                    }
                    ticksKeyHeld = 0;
                    holding = false;
                }
            } else if (ticksKeyHeld > 10) {
                ticksKeyHeld = 10;
            }
        } else {
            ticksKeyHeld = Math.max(0, ticksKeyHeld - 2);
        }
    }

    private static boolean isKeyHeld() {
        int keyCode = OpenGuideHotkey.getHotkey().getKey().m_84873_();
        long window = Minecraft.m_91087_().m_91268_().m_85439_();
        return InputConstants.m_84830_((long)window, (int)keyCode);
    }

    private static boolean isKeyBound() {
        return !OPEN_GUIDE_MAPPING.m_90862_();
    }

    public static KeyMapping getHotkey() {
        return OPEN_GUIDE_MAPPING;
    }

    static {
        OPEN_GUIDE_MAPPING.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.GUI);
        LOG = LoggerFactory.getLogger(OpenGuideHotkey.class);
        TOOLTIP_PHASE = AppEng.makeId("open_guide_for_item");
        newTick = true;
    }
}

