/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.layout;

import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.layout.FontMetrics;
import appeng.client.guidebook.style.ResolvedTextStyle;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Stream;

public class LayoutContext
implements FontMetrics {
    private final FontMetrics fontMetrics;
    private final List<LytRect> leftFloats = new ArrayList<LytRect>();
    private final List<LytRect> rightFloats = new ArrayList<LytRect>();

    public LayoutContext(FontMetrics fontMetrics) {
        this.fontMetrics = fontMetrics;
    }

    public void addLeftFloat(LytRect bounds) {
        this.leftFloats.add(bounds);
    }

    public void addRightFloat(LytRect bounds) {
        this.rightFloats.add(bounds);
    }

    public OptionalInt getLeftFloatRightEdge() {
        return this.leftFloats.stream().mapToInt(LytRect::right).max();
    }

    public OptionalInt getRightFloatLeftEdge() {
        return this.rightFloats.stream().mapToInt(LytRect::x).min();
    }

    public OptionalInt clearFloats(boolean left, boolean right) {
        if (left && right) {
            OptionalInt result = Streams.concat((Stream[])new Stream[]{this.leftFloats.stream(), this.rightFloats.stream()}).mapToInt(LytRect::bottom).max();
            this.leftFloats.clear();
            this.rightFloats.clear();
            return result;
        }
        if (left) {
            OptionalInt result = this.leftFloats.stream().mapToInt(LytRect::bottom).max();
            this.leftFloats.clear();
            return result;
        }
        if (right) {
            OptionalInt result = this.rightFloats.stream().mapToInt(LytRect::bottom).max();
            this.rightFloats.clear();
            return result;
        }
        return OptionalInt.empty();
    }

    public void clearFloatsAbove(int y) {
        this.leftFloats.removeIf(f -> f.bottom() <= y);
        this.rightFloats.removeIf(f -> f.bottom() <= y);
    }

    @Override
    public float getAdvance(int codePoint, ResolvedTextStyle style) {
        return this.fontMetrics.getAdvance(codePoint, style);
    }

    @Override
    public int getLineHeight(ResolvedTextStyle style) {
        return this.fontMetrics.getLineHeight(style);
    }

    public OptionalInt getNextFloatBottomEdge(int y) {
        return Streams.concat((Stream[])new Stream[]{this.leftFloats.stream(), this.rightFloats.stream()}).mapToInt(LytRect::bottom).filter(bottom -> bottom > y).min();
    }
}

