/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene.annotation;

import appeng.client.guidebook.color.MutableColor;
import appeng.client.guidebook.scene.annotation.InWorldAnnotation;
import appeng.client.guidebook.scene.annotation.InWorldBoxAnnotation;
import appeng.client.guidebook.scene.annotation.InWorldLineAnnotation;
import appeng.core.AppEng;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class InWorldAnnotationRenderer {
    private static final RenderType OCCLUDED = RenderType.m_173215_((String)"annotation_occluded", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x100000, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110671_(RenderType.f_110152_).m_173292_(RenderType.f_173110_).m_173290_((RenderStateShard.EmptyTextureStateShard)RenderStateShard.f_110145_).m_110685_(RenderStateShard.f_110139_).m_110663_(new RenderStateShard.DepthTestStateShard(">", 516)).m_110687_(RenderStateShard.f_110115_).m_110691_(false));

    private InWorldAnnotationRenderer() {
    }

    public static void render(MultiBufferSource.BufferSource buffers, Iterable<InWorldAnnotation> annotations) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(AppEng.makeId("block/noise"));
        VertexConsumer occludedConsumer = buffers.m_6299_(OCCLUDED);
        for (InWorldAnnotation annotation : annotations) {
            MutableColor color;
            if (annotation.isAlwaysOnTop()) continue;
            if (annotation instanceof InWorldBoxAnnotation) {
                InWorldBoxAnnotation boxAnnotation = (InWorldBoxAnnotation)annotation;
                color = MutableColor.of(boxAnnotation.color());
                color.darker(50.0f).setAlpha(color.alpha() * 0.5f);
                if (boxAnnotation.isHovered()) {
                    color.lighter(50.0f);
                }
                InWorldAnnotationRenderer.render(occludedConsumer, boxAnnotation.min(), boxAnnotation.max(), color.toArgb32(), boxAnnotation.thickness(), sprite);
                continue;
            }
            if (!(annotation instanceof InWorldLineAnnotation)) continue;
            InWorldLineAnnotation lineAnnotation = (InWorldLineAnnotation)annotation;
            color = MutableColor.of(lineAnnotation.color());
            color.darker(50.0f).setAlpha(color.alpha() * 0.5f);
            if (lineAnnotation.isHovered()) {
                color.lighter(50.0f);
            }
            InWorldAnnotationRenderer.strut(occludedConsumer, lineAnnotation.min(), lineAnnotation.max(), color.toArgb32(), lineAnnotation.thickness(), true, true, sprite);
        }
        buffers.m_109912_(OCCLUDED);
        for (int pass = 1; pass <= 2; ++pass) {
            if (pass == 2) {
                RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
            }
            VertexConsumer consumer = buffers.m_6299_(RenderType.m_110466_());
            for (InWorldAnnotation annotation : annotations) {
                MutableColor color;
                if (annotation.isAlwaysOnTop() != (pass == 2)) continue;
                if (annotation instanceof InWorldBoxAnnotation) {
                    InWorldBoxAnnotation boxAnnotation = (InWorldBoxAnnotation)annotation;
                    color = MutableColor.of(boxAnnotation.color());
                    if (boxAnnotation.isHovered()) {
                        color.lighter(50.0f);
                    }
                    InWorldAnnotationRenderer.render(consumer, boxAnnotation.min(), boxAnnotation.max(), color.toArgb32(), boxAnnotation.thickness(), sprite);
                    continue;
                }
                if (!(annotation instanceof InWorldLineAnnotation)) continue;
                InWorldLineAnnotation lineAnnotation = (InWorldLineAnnotation)annotation;
                color = MutableColor.of(lineAnnotation.color());
                if (lineAnnotation.isHovered()) {
                    color.lighter(50.0f);
                }
                InWorldAnnotationRenderer.strut(consumer, lineAnnotation.min(), lineAnnotation.max(), color.toArgb32(), lineAnnotation.thickness(), true, true, sprite);
            }
            buffers.m_109912_(RenderType.m_110466_());
        }
        buffers.m_109911_();
    }

    public static void render(VertexConsumer consumer, Vector3f min, Vector3f max, int color, float thickness, TextureAtlasSprite sprite) {
        float thickHalf = thickness * 0.5f;
        Vector3f u = new Vector3f(max.x - min.x, 0.0f, 0.0f);
        Vector3f v = new Vector3f(0.0f, max.y - min.y, 0.0f);
        Vector3f t = new Vector3f(0.0f, 0.0f, max.z - min.z);
        Vector3f uNorm = new Vector3f((Vector3fc)u).normalize();
        Vector3f vNorm = new Vector3f((Vector3fc)v).normalize();
        Vector3f tNorm = new Vector3f((Vector3fc)t).normalize();
        Vector3f[] corners = new Vector3f[]{new Vector3f((Vector3fc)min), new Vector3f((Vector3fc)min).add((Vector3fc)u), new Vector3f((Vector3fc)min).add((Vector3fc)v), new Vector3f((Vector3fc)min).add((Vector3fc)t), new Vector3f((Vector3fc)max), new Vector3f((Vector3fc)max).sub((Vector3fc)u), new Vector3f((Vector3fc)max).sub((Vector3fc)v), new Vector3f((Vector3fc)max).sub((Vector3fc)t)};
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)uNorm).mulAdd(-thickHalf, (Vector3fc)corners[0]), new Vector3f((Vector3fc)uNorm).mulAdd(thickHalf, (Vector3fc)corners[1]), color, thickness, true, true, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)uNorm).mulAdd(-thickHalf, (Vector3fc)corners[2]), new Vector3f((Vector3fc)uNorm).mulAdd(thickHalf, (Vector3fc)corners[7]), color, thickness, true, true, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)uNorm).mulAdd(-thickHalf, (Vector3fc)corners[3]), new Vector3f((Vector3fc)uNorm).mulAdd(thickHalf, (Vector3fc)corners[6]), color, thickness, true, true, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)uNorm).mulAdd(-thickHalf, (Vector3fc)corners[5]), new Vector3f((Vector3fc)uNorm).mulAdd(thickHalf, (Vector3fc)corners[4]), color, thickness, true, true, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)vNorm).mulAdd(thickHalf, (Vector3fc)corners[0]), new Vector3f((Vector3fc)vNorm).mulAdd(-thickHalf, (Vector3fc)corners[2]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)vNorm).mulAdd(thickHalf, (Vector3fc)corners[1]), new Vector3f((Vector3fc)vNorm).mulAdd(-thickHalf, (Vector3fc)corners[7]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)vNorm).mulAdd(thickHalf, (Vector3fc)corners[3]), new Vector3f((Vector3fc)vNorm).mulAdd(-thickHalf, (Vector3fc)corners[5]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)vNorm).mulAdd(thickHalf, (Vector3fc)corners[6]), new Vector3f((Vector3fc)vNorm).mulAdd(-thickHalf, (Vector3fc)corners[4]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)tNorm).mulAdd(thickHalf, (Vector3fc)corners[0]), new Vector3f((Vector3fc)tNorm).mulAdd(-thickHalf, (Vector3fc)corners[3]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)tNorm).mulAdd(thickHalf, (Vector3fc)corners[1]), new Vector3f((Vector3fc)tNorm).mulAdd(-thickHalf, (Vector3fc)corners[6]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)tNorm).mulAdd(thickHalf, (Vector3fc)corners[2]), new Vector3f((Vector3fc)tNorm).mulAdd(-thickHalf, (Vector3fc)corners[5]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)tNorm).mulAdd(thickHalf, (Vector3fc)corners[7]), new Vector3f((Vector3fc)tNorm).mulAdd(-thickHalf, (Vector3fc)corners[4]), color, thickness, false, false, sprite);
    }

    private static void strut(VertexConsumer consumer, Vector3f from, Vector3f to, int color, float thickness, boolean startCap, boolean endCap, TextureAtlasSprite sprite) {
        Vector3f norm = new Vector3f((Vector3fc)to).sub((Vector3fc)from).normalize();
        Vector3f prefUp = Math.abs(from.x - to.x) < 0.01f && Math.abs(from.z - to.z) < 0.01f ? new Vector3f(1.0f, 0.0f, 0.0f) : new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f rightNorm = new Vector3f((Vector3fc)norm).cross((Vector3fc)prefUp).normalize();
        Vector3f leftNorm = new Vector3f((Vector3fc)rightNorm).negate();
        Vector3f upNorm = new Vector3f((Vector3fc)rightNorm).cross((Vector3fc)norm).normalize();
        Vector3f downNorm = new Vector3f((Vector3fc)upNorm).negate();
        Vector3f up = new Vector3f((Vector3fc)upNorm).mul(thickness * 0.5f);
        Vector3f right = new Vector3f((Vector3fc)rightNorm).mul(thickness * 0.5f);
        if (startCap) {
            InWorldAnnotationRenderer.quad(consumer, downNorm, color, new Vector3f((Vector3fc)from).add((Vector3fc)up).sub((Vector3fc)right), new Vector3f((Vector3fc)from).sub((Vector3fc)up).sub((Vector3fc)right), new Vector3f((Vector3fc)from).sub((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)from).add((Vector3fc)up).add((Vector3fc)right), sprite);
        }
        if (endCap) {
            InWorldAnnotationRenderer.quad(consumer, norm, color, new Vector3f((Vector3fc)to).add((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)to).sub((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)to).sub((Vector3fc)up).sub((Vector3fc)right), new Vector3f((Vector3fc)to).add((Vector3fc)up).sub((Vector3fc)right), sprite);
        }
        InWorldAnnotationRenderer.quad(consumer, leftNorm, color, new Vector3f((Vector3fc)from).sub((Vector3fc)right).add((Vector3fc)up), new Vector3f((Vector3fc)to).sub((Vector3fc)right).add((Vector3fc)up), new Vector3f((Vector3fc)to).sub((Vector3fc)right).sub((Vector3fc)up), new Vector3f((Vector3fc)from).sub((Vector3fc)right).sub((Vector3fc)up), sprite);
        InWorldAnnotationRenderer.quad(consumer, rightNorm, color, new Vector3f((Vector3fc)to).add((Vector3fc)right).sub((Vector3fc)up), new Vector3f((Vector3fc)to).add((Vector3fc)right).add((Vector3fc)up), new Vector3f((Vector3fc)from).add((Vector3fc)right).add((Vector3fc)up), new Vector3f((Vector3fc)from).add((Vector3fc)right).sub((Vector3fc)up), sprite);
        InWorldAnnotationRenderer.quad(consumer, upNorm, color, new Vector3f((Vector3fc)from).add((Vector3fc)up).sub((Vector3fc)right), new Vector3f((Vector3fc)from).add((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)to).add((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)to).add((Vector3fc)up).sub((Vector3fc)right), sprite);
        InWorldAnnotationRenderer.quad(consumer, downNorm, color, new Vector3f((Vector3fc)to).sub((Vector3fc)up).sub((Vector3fc)right), new Vector3f((Vector3fc)to).sub((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)from).sub((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)from).sub((Vector3fc)up).sub((Vector3fc)right), sprite);
    }

    private static void quad(VertexConsumer consumer, Vector3f faceNormal, int color, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, TextureAtlasSprite sprite) {
        Direction d = Direction.m_122372_((float)faceNormal.x, (float)faceNormal.y, (float)faceNormal.z);
        float shade = switch (d) {
            case Direction.DOWN -> 0.5f;
            case Direction.NORTH, Direction.SOUTH -> 0.8f;
            case Direction.WEST, Direction.EAST -> 0.6f;
            default -> 1.0f;
        };
        color = FastColor.ARGB32.m_13657_((int)FastColor.ARGB32.m_13660_((int)255, (int)((int)(shade * 255.0f)), (int)((int)(shade * 255.0f)), (int)((int)(shade * 255.0f))), (int)color);
        InWorldAnnotationRenderer.vertex(consumer, faceNormal, color, v1, sprite.m_118409_(), sprite.m_118412_());
        InWorldAnnotationRenderer.vertex(consumer, faceNormal, color, v2, sprite.m_118409_(), sprite.m_118411_());
        InWorldAnnotationRenderer.vertex(consumer, faceNormal, color, v3, sprite.m_118410_(), sprite.m_118411_());
        InWorldAnnotationRenderer.vertex(consumer, faceNormal, color, v4, sprite.m_118410_(), sprite.m_118412_());
    }

    private static void vertex(VertexConsumer consumer, Vector3f faceNormal, int color, Vector3f bottomLeft, float u, float v) {
        consumer.m_5483_((double)bottomLeft.x, (double)bottomLeft.y, (double)bottomLeft.z).m_193479_(color).m_7421_(u, v).m_85969_(0xF000F0).m_5601_(faceNormal.x(), faceNormal.y(), faceNormal.z()).m_5752_();
    }
}

