/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.config;

import appeng.core.config.BaseOption;
import appeng.core.config.BooleanOption;
import appeng.core.config.DoubleOption;
import appeng.core.config.EnumOption;
import appeng.core.config.IntegerOption;
import appeng.core.config.StringListOption;
import appeng.core.config.StringOption;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ConfigSection {
    private final ConfigSection parent;
    private final List<ConfigSection> subsections = new ArrayList<ConfigSection>();
    private final List<BaseOption> options = new ArrayList<BaseOption>();
    private final String id;
    private final String fullId;
    private final String comment;
    private Runnable changeListener;

    private ConfigSection(String id, String comment) {
        this.parent = null;
        this.id = id;
        this.fullId = id;
        this.comment = comment;
    }

    private ConfigSection(ConfigSection parent, String id, String comment) {
        this.parent = parent;
        this.id = id;
        this.comment = comment;
        this.fullId = parent.fullId != null ? parent.fullId + "." + id : id;
    }

    public static ConfigSection createRoot() {
        return new ConfigSection(null, null);
    }

    public ConfigSection subsection(String id) {
        return this.subsection(id, null);
    }

    public ConfigSection subsection(String id, String comment) {
        ConfigSection section = new ConfigSection(this, id, comment);
        this.subsections.add(section);
        return section;
    }

    private <T extends BaseOption> T addOption(T option) {
        this.options.add(option);
        return option;
    }

    public StringOption addString(String id, String defaultValue) {
        return this.addString(id, defaultValue, null);
    }

    public StringOption addString(String id, String defaultValue, @Nullable String comment) {
        return this.addOption(new StringOption(this, id, comment, defaultValue));
    }

    public IntegerOption addInt(String id, int defaultValue) {
        return this.addInt(id, defaultValue, null);
    }

    public IntegerOption addInt(String id, int defaultValue, @Nullable String comment) {
        return this.addInt(id, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE, comment);
    }

    public IntegerOption addInt(String id, int defaultValue, int minValue, int maxValue, @Nullable String comment) {
        return this.addOption(new IntegerOption(this, id, comment, defaultValue, minValue, maxValue));
    }

    public DoubleOption addDouble(String id, double defaultValue) {
        return this.addDouble(id, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public DoubleOption addDouble(String id, double defaultValue, @Nullable String comment) {
        return this.addDouble(id, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE, comment);
    }

    public DoubleOption addDouble(String id, double defaultValue, double minValue, double maxValue) {
        return this.addDouble(id, defaultValue, minValue, maxValue, null);
    }

    public DoubleOption addDouble(String id, double defaultValue, double minValue, double maxValue, @Nullable String comment) {
        return this.addOption(new DoubleOption(this, id, comment, defaultValue, minValue, maxValue));
    }

    public BooleanOption addBoolean(String id, boolean defaultValue) {
        return this.addBoolean(id, defaultValue, null);
    }

    public BooleanOption addBoolean(String id, boolean defaultValue, @Nullable String comment) {
        return this.addOption(new BooleanOption(this, id, comment, defaultValue));
    }

    public StringListOption addStringList(String id, List<String> defaultValue) {
        return this.addStringList(id, defaultValue, null);
    }

    public StringListOption addStringList(String id, List<String> defaultValue, @Nullable String comment) {
        return this.addOption(new StringListOption(this, id, comment, defaultValue));
    }

    public <T extends Enum<T>> EnumOption<T> addEnum(String id, T defaultValue) {
        return this.addEnum(id, defaultValue, null);
    }

    public <T extends Enum<T>> EnumOption<T> addEnum(String id, T defaultValue, @Nullable String comment) {
        return this.addOption(new EnumOption<T>(this, id, comment, defaultValue));
    }

    public void setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
    }

    public void markDirty() {
        if (this.changeListener != null) {
            this.changeListener.run();
        }
        if (this.parent != null) {
            this.parent.markDirty();
        }
    }

    public JsonObject write() {
        JsonObject obj = new JsonObject();
        if (this.comment != null) {
            obj.addProperty("_comment", this.comment);
        }
        for (BaseOption option : this.options) {
            if (option.comment != null) {
                obj.addProperty(option.id + "_comment", option.comment);
            }
            obj.add(option.id, option.write());
        }
        for (ConfigSection subsection : this.subsections) {
            obj.add(subsection.id, (JsonElement)subsection.write());
        }
        return obj;
    }

    public void read(JsonObject obj) {
        for (BaseOption option : this.options) {
            if (!obj.has(option.id)) continue;
            option.read(obj.get(option.id));
        }
        for (ConfigSection subsection : this.subsections) {
            if (!obj.has(subsection.id)) continue;
            subsection.read(obj.getAsJsonObject(subsection.id));
        }
    }
}

