/*
 * Decompiled with CFR 0.152.
 */
package appeng.libs.micromark;

import appeng.libs.micromark.CharUtil;
import appeng.libs.micromark.ContentType;
import appeng.libs.micromark.InitialConstruct;
import appeng.libs.micromark.State;
import appeng.libs.micromark.Token;
import appeng.libs.micromark.TokenizeContext;
import appeng.libs.micromark.Tokenizer;
import appeng.libs.micromark.factory.FactorySpace;

public final class InitializeContent {
    public static final InitialConstruct content = new InitialConstruct();

    private InitializeContent() {
    }

    static {
        InitializeContent.content.tokenize = (context, effects, ok, nok) -> new StateMachine((TokenizeContext)context, (Tokenizer.Effects)effects).contentStart;
    }

    private static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private Token previous;
        public final State contentStart;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects) {
            this.context = context;
            this.effects = effects;
            this.contentStart = effects.attempt.hook(context.getParser().constructs.contentInitial, this::afterContentStartConstruct, this::paragraphInitial);
        }

        private State afterContentStartConstruct(int code) {
            if (code != Integer.MIN_VALUE && !CharUtil.markdownLineEnding(code)) {
                throw new IllegalStateException("expected eol or eof");
            }
            if (code == Integer.MIN_VALUE) {
                this.effects.consume(code);
                return null;
            }
            this.effects.enter("lineEnding");
            this.effects.consume(code);
            this.effects.exit("lineEnding");
            return FactorySpace.create(this.effects, this.contentStart, "linePrefix");
        }

        private State paragraphInitial(int code) {
            if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                throw new IllegalStateException("expected anything other than a line ending or EOF");
            }
            this.effects.enter("paragraph");
            return this.lineStart(code);
        }

        private State lineStart(int code) {
            Token tokenFields = new Token();
            tokenFields.contentType = ContentType.TEXT;
            tokenFields.previous = this.previous;
            Token token = this.effects.enter("chunkText", tokenFields);
            if (this.previous != null) {
                this.previous.next = token;
            }
            this.previous = token;
            return this.data(code);
        }

        private State data(int code) {
            if (code == Integer.MIN_VALUE) {
                this.effects.exit("chunkText");
                this.effects.exit("paragraph");
                this.effects.consume(code);
                return null;
            }
            if (CharUtil.markdownLineEnding(code)) {
                this.effects.consume(code);
                this.effects.exit("chunkText");
                return this::lineStart;
            }
            this.effects.consume(code);
            return this::data;
        }
    }
}

