/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.helpers;

import appeng.api.config.FuzzyMode;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class ItemComparisonHelper {
    private ItemComparisonHelper() {
    }

    public static boolean isEqualItemType(ItemStack that, ItemStack other) {
        return !that.m_41619_() && !other.m_41619_() && that.m_41720_() == other.m_41720_();
    }

    public boolean isNbtTagEqual(@Nullable CompoundTag left, @Nullable CompoundTag right) {
        boolean isRightEmpty;
        if (left == right) {
            return true;
        }
        boolean isLeftEmpty = left == null || left.m_128456_();
        boolean bl = isRightEmpty = right == null || right.m_128456_();
        if (isLeftEmpty && isRightEmpty) {
            return true;
        }
        if (isLeftEmpty != isRightEmpty) {
            return false;
        }
        return left.equals((Object)right);
    }

    public static boolean isFuzzyEqualItem(ItemStack a, ItemStack b, FuzzyMode mode) {
        if (a.m_41619_() && b.m_41619_()) {
            return true;
        }
        if (a.m_41619_() || b.m_41619_()) {
            return false;
        }
        if (a.m_41720_() == b.m_41720_() && a.m_41720_().m_41465_()) {
            if (mode == FuzzyMode.IGNORE_ALL) {
                return true;
            }
            if (mode == FuzzyMode.PERCENT_99) {
                return a.m_41773_() > 0 == b.m_41773_() > 0;
            }
            float percentDamagedOfA = (float)a.m_41773_() / (float)a.m_41776_();
            float percentDamagedOfB = (float)b.m_41773_() / (float)b.m_41776_();
            return percentDamagedOfA > mode.breakPoint == percentDamagedOfB > mode.breakPoint;
        }
        return ItemStack.m_41656_((ItemStack)a, (ItemStack)b);
    }
}

