/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.item;

import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.core.localization.PlayerMessages;
import appeng.items.AEBaseItem;
import appeng.items.storage.BasicStorageCell;
import appeng.items.storage.StorageTier;
import gripe._90.arseng.definition.ArsEngItems;
import gripe._90.arseng.me.cell.ISourceCellItem;
import gripe._90.arseng.me.cell.SourceCellHandler;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import org.jetbrains.annotations.NotNull;

public class SourceCellItem
extends AEBaseItem
implements ISourceCellItem {
    private final StorageTier tier;
    private final ItemLike housing;

    public SourceCellItem(Item.Properties properties, StorageTier tier, ItemLike housing) {
        super(properties);
        this.tier = tier;
        this.housing = housing;
    }

    public StorageTier getTier() {
        return this.tier;
    }

    @Override
    public long getTotalBytes() {
        return 100L * (long)Math.pow(4.0, this.tier.index() - 1);
    }

    @Override
    public double getIdleDrain() {
        return this.tier.idleDrain();
    }

    public IUpgradeInventory getUpgrades(ItemStack stack) {
        return UpgradeInventories.forItem((ItemStack)stack, (int)1);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack inHand = player.m_21120_(hand);
        this.disassemble(inHand, level, player);
        return new InteractionResultHolder(InteractionResult.m_19078_((boolean)level.m_5776_()), (Object)inHand);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return this.disassemble(stack, context.m_43725_(), context.m_43723_()) ? InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_()) : InteractionResult.PASS;
    }

    private boolean disassemble(ItemStack stack, Level level, Player player) {
        if (player != null && player.m_6144_()) {
            if (level.m_5776_()) {
                return false;
            }
            Inventory playerInv = player.m_150109_();
            StorageCell cellInv = StorageCells.getCellInventory((ItemStack)stack, null);
            if (cellInv != null && playerInv.m_36056_() == stack) {
                if (cellInv.getAvailableStacks().isEmpty()) {
                    playerInv.m_6836_(playerInv.f_35977_, ItemStack.f_41583_);
                    playerInv.m_150079_(((Item)this.tier.componentSupplier().get()).m_7968_());
                    for (ItemStack upgrade : this.getUpgrades(stack)) {
                        playerInv.m_150079_(upgrade);
                    }
                    playerInv.m_150079_(this.housing.m_5456_().m_7968_());
                    return true;
                }
                player.m_5661_((Component)PlayerMessages.OnlyEmptyCellsCanBeDisassembled.text(), true);
            }
        }
        return false;
    }

    public void m_7373_(@NotNull ItemStack stack, Level level, @NotNull List<Component> lines, @NotNull TooltipFlag advTooltips) {
        SourceCellHandler.INSTANCE.addCellInformationToTooltip(stack, lines);
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack stack) {
        return SourceCellHandler.INSTANCE.getTooltipImage(stack);
    }

    public static void initColours(RegisterColorHandlersEvent.Item event) {
        ArsEngItems.getCells().forEach(cell -> event.register(BasicStorageCell::getColor, new ItemLike[]{cell}));
    }
}

