/*
 * Decompiled with CFR 0.152.
 */
package me.whirlfrenzy.itemdespawntimer.mixin;

import java.util.ArrayList;
import me.whirlfrenzy.itemdespawntimer.access.ItemEntityAccessInterface;
import me.whirlfrenzy.itemdespawntimer.mixin.EntityMixin;
import me.whirlfrenzy.itemdespawntimer.networking.PacketReceiver;
import me.whirlfrenzy.itemdespawntimer.networking.SetItemAgeInstance;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraftforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends EntityMixin
implements ItemEntityAccessInterface {
    @Shadow
    private int f_31985_;
    @Unique
    boolean timerLabelVisibility = true;
    @Unique
    int previousTickItemAge = -1;
    @Unique
    int modItemAge = 0;
    @Unique
    ArrayList<ServerPlayer> playersInRange = new ArrayList();

    @Shadow
    public abstract int m_32059_();

    @Override
    public boolean item_despawn_timer$getTimerLabelVisibility() {
        return this.timerLabelVisibility;
    }

    @Override
    public void item_despawn_timer$setTimerLabelVisibility(boolean newTimerLabelVisibility) {
        this.timerLabelVisibility = newTimerLabelVisibility;
    }

    @Override
    public int item_despawn_timer$getModItemAge() {
        return this.modItemAge;
    }

    @Override
    public void item_despawn_timer$setModItemAge(int modItemAge) {
        this.modItemAge = modItemAge;
    }

    @Unique
    public void item_despawn_timer$sendItemAgePacket(ServerPlayer player) {
        PacketReceiver.simpleChannelInstance.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SetItemAgeInstance((ItemEntity)this));
    }

    @Override
    public void onStartedTrackingBy(ServerPlayer player, CallbackInfo ci) {
        this.item_despawn_timer$sendItemAgePacket(player);
        this.playersInRange.add(player);
    }

    @Override
    public void onStoppedTrackingBy(ServerPlayer player, CallbackInfo ci) {
        this.playersInRange.remove(player);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        if (!this.m_9236_().m_5776_()) {
            if (this.previousTickItemAge != -1 && this.previousTickItemAge != this.m_32059_() - 1 && this.previousTickItemAge != Short.MIN_VALUE) {
                for (ServerPlayer player : this.playersInRange) {
                    this.item_despawn_timer$sendItemAgePacket(player);
                }
            }
            this.previousTickItemAge = this.m_32059_();
        } else {
            ++this.modItemAge;
        }
    }
}

