/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.configurabledespawntimer_common_forge.mixin;

import com.natamus.collective_common_forge.functions.TaskFunctions;
import com.natamus.configurabledespawntimer_common_forge.config.ConfigHandler;
import com.natamus.configurabledespawntimer_common_forge.util.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class}, priority=1001)
public abstract class ItemEntityMixin {
    @Shadow
    @Final
    private static int f_149659_;
    @Shadow
    @Final
    private static int f_149661_;
    @Shadow
    private int f_31985_;

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="TAIL")})
    public void ItemEntity(EntityType<?> entityType, Level level, CallbackInfo ci) {
        TaskFunctions.enqueueImmediateTask((Level)level, () -> {
            ItemEntity itemEntity = (ItemEntity)this;
            if (ItemEntityMixin.shouldSetAge(itemEntity)) {
                this.f_31985_ = ItemEntityMixin.getAgeToSet(itemEntity);
            }
        }, (boolean)true);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;DDD)V"}, at={@At(value="TAIL")})
    public void ItemEntity(Level level, double x, double y, double z, ItemStack itemStack, double xd, double yd, double zd, CallbackInfo ci) {
        TaskFunctions.enqueueImmediateTask((Level)level, () -> {
            ItemEntity itemEntity = (ItemEntity)this;
            if (ItemEntityMixin.shouldSetAge(itemEntity)) {
                this.f_31985_ = ItemEntityMixin.getAgeToSet(itemEntity);
            }
        }, (boolean)true);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/item/ItemEntity;)V"}, at={@At(value="TAIL")})
    private void ItemEntity(ItemEntity itemEntityIn, CallbackInfo ci) {
        TaskFunctions.enqueueImmediateTask((Level)itemEntityIn.m_9236_(), () -> {
            ItemEntity itemEntity = (ItemEntity)this;
            if (ItemEntityMixin.shouldSetAge(itemEntity)) {
                this.f_31985_ = ItemEntityMixin.getAgeToSet(itemEntity);
            }
        }, (boolean)true);
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/item/ItemEntity;updateInWaterStateAndDoFluidPushing()Z")})
    public void tick(CallbackInfo ci) {
        if (this.f_31985_ == f_149661_ && !((ItemEntity)this).m_19880_().contains("configurabledespawntimer.infinite_lifetime")) {
            ++this.f_31985_;
        }
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        compoundTag.m_128405_("ActualAge", this.f_31985_);
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        if (compoundTag.m_128441_("ActualAge")) {
            this.f_31985_ = compoundTag.m_128451_("ActualAge");
        }
    }

    @Unique
    private static boolean shouldSetAge(ItemEntity itemEntity) {
        if (itemEntity.m_32059_() == 5999 && itemEntity.m_32063_()) {
            return false;
        }
        if (itemEntity.m_19880_().contains("configurabledespawntimer.set")) {
            return false;
        }
        itemEntity.m_20049_("configurabledespawntimer.set");
        if (itemEntity.m_32059_() == f_149661_) {
            itemEntity.m_20049_("configurabledespawntimer.infinite_lifetime");
            return false;
        }
        return true;
    }

    @Unique
    private static int getAgeToSet(ItemEntity itemEntity) {
        if (ConfigHandler.preventDespawnForPlayerItems && itemEntity.m_19880_().contains("configurabledespawntimer.player_drop")) {
            itemEntity.m_20049_("configurabledespawntimer.infinite_lifetime");
            return f_149661_;
        }
        Item item = itemEntity.m_32055_().m_41720_();
        if (Util.itemSpecificDespawnTime.containsKey(item)) {
            int despawnTime = Util.itemSpecificDespawnTime.get(item);
            if (despawnTime == 0) {
                itemEntity.m_20049_("configurabledespawntimer.infinite_lifetime");
                return f_149661_;
            }
            return despawnTime * -1 + f_149659_;
        }
        return ConfigHandler.globalItemDespawnTimeInTicks * -1 + f_149659_;
    }
}

