/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.blockentity;

import com.aetherteam.aether.advancement.IncubationTrigger;
import com.aetherteam.aether.blockentity.AetherBlockEntityTypes;
import com.aetherteam.aether.inventory.menu.IncubatorMenu;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import com.aetherteam.aether.recipe.recipes.item.IncubationRecipe;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class IncubatorBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible {
    private static final int[] SLOTS_NS = new int[]{0};
    private static final int[] SLOTS_EW = new int[]{1};
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private ServerPlayer player;
    private int litTime;
    private int litDuration;
    private int incubationProgress;
    private int incubationTotalTime;
    private int x;
    private int y;
    private int z;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> IncubatorBlockEntity.this.litTime;
                case 1 -> IncubatorBlockEntity.this.litDuration;
                case 2 -> IncubatorBlockEntity.this.incubationProgress;
                case 3 -> IncubatorBlockEntity.this.incubationTotalTime;
                case 4 -> IncubatorBlockEntity.this.x;
                case 5 -> IncubatorBlockEntity.this.y;
                case 6 -> IncubatorBlockEntity.this.z;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    IncubatorBlockEntity.this.litTime = value;
                    break;
                }
                case 1: {
                    IncubatorBlockEntity.this.litDuration = value;
                    break;
                }
                case 2: {
                    IncubatorBlockEntity.this.incubationProgress = value;
                    break;
                }
                case 3: {
                    IncubatorBlockEntity.this.incubationTotalTime = value;
                    break;
                }
                case 4: {
                    IncubatorBlockEntity.this.x = value;
                    break;
                }
                case 5: {
                    IncubatorBlockEntity.this.y = value;
                    break;
                }
                case 6: {
                    IncubatorBlockEntity.this.z = value;
                }
            }
        }

        public int m_6499_() {
            return 7;
        }
    };
    private static final Map<Item, Integer> incubatingMap = new LinkedHashMap<Item, Integer>();
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeManager.CachedCheck<Container, IncubationRecipe> quickCheck;
    private LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST});

    public IncubatorBlockEntity(BlockPos pos, BlockState state) {
        this(pos, state, (RecipeType<IncubationRecipe>)((RecipeType)AetherRecipeTypes.INCUBATION.get()));
    }

    public IncubatorBlockEntity(BlockPos pos, BlockState state, RecipeType<IncubationRecipe> recipeType) {
        super((BlockEntityType)AetherBlockEntityTypes.INCUBATOR.get(), pos, state);
        this.quickCheck = RecipeManager.m_220267_(recipeType);
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory playerInventory) {
        return new IncubatorMenu(id, playerInventory, (Container)this, this.dataAccess);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction direction) {
        if (!this.f_58859_ && direction != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (direction == Direction.NORTH) {
                return this.handlers[0].cast();
            }
            if (direction == Direction.SOUTH) {
                return this.handlers[1].cast();
            }
            if (direction == Direction.EAST) {
                return this.handlers[2].cast();
            }
            return this.handlers[3].cast();
        }
        return super.getCapability(capability, direction);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST});
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, IncubatorBlockEntity blockEntity) {
        boolean flag3;
        boolean flag = blockEntity.isLit();
        boolean flag1 = false;
        if (blockEntity.isLit()) {
            --blockEntity.litTime;
        }
        ItemStack itemstack = (ItemStack)blockEntity.items.get(1);
        boolean flag2 = !((ItemStack)blockEntity.items.get(0)).m_41619_();
        boolean bl = flag3 = !itemstack.m_41619_();
        if (blockEntity.isLit() || flag3 && flag2) {
            IncubationRecipe recipe = flag2 ? (IncubationRecipe)blockEntity.quickCheck.m_213657_((Container)blockEntity, level).orElse(null) : null;
            if (!blockEntity.isLit() && blockEntity.canIncubate(recipe, blockEntity.items)) {
                blockEntity.litDuration = blockEntity.litTime = blockEntity.getBurnDuration(itemstack);
                if (blockEntity.isLit()) {
                    flag1 = true;
                    if (itemstack.hasCraftingRemainingItem()) {
                        blockEntity.items.set(1, (Object)itemstack.getCraftingRemainingItem());
                    } else if (flag3) {
                        itemstack.m_41774_(1);
                        if (itemstack.m_41619_()) {
                            blockEntity.items.set(1, (Object)itemstack.getCraftingRemainingItem());
                        }
                    }
                }
            }
            if (blockEntity.isLit() && blockEntity.canIncubate(recipe, blockEntity.items)) {
                ++blockEntity.incubationProgress;
                if (blockEntity.incubationProgress == blockEntity.incubationTotalTime) {
                    blockEntity.incubationProgress = 0;
                    blockEntity.incubationTotalTime = IncubatorBlockEntity.getTotalIncubationTime(level, blockEntity);
                    if (blockEntity.incubate(recipe, blockEntity.items)) {
                        blockEntity.m_6029_(recipe);
                    }
                    flag1 = true;
                }
            } else {
                blockEntity.incubationProgress = 0;
            }
        } else if (!blockEntity.isLit() && blockEntity.incubationProgress > 0) {
            blockEntity.incubationProgress = Mth.m_14045_((int)(blockEntity.incubationProgress - 2), (int)0, (int)blockEntity.incubationTotalTime);
        }
        if (flag != blockEntity.isLit()) {
            flag1 = true;
            state = (BlockState)state.m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(blockEntity.isLit()));
            level.m_7731_(pos, state, 3);
        }
        if (flag1) {
            IncubatorBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
        if (blockEntity.x != pos.m_123341_()) {
            blockEntity.x = pos.m_123341_();
        }
        if (blockEntity.y != pos.m_123342_()) {
            blockEntity.y = pos.m_123342_();
        }
        if (blockEntity.z != pos.m_123343_()) {
            blockEntity.z = pos.m_123343_();
        }
    }

    private boolean incubate(@Nullable IncubationRecipe recipe, NonNullList<ItemStack> stacks) {
        if (recipe != null && this.canIncubate(recipe, stacks)) {
            Level level;
            ItemStack itemStack = (ItemStack)stacks.get(0);
            EntityType<?> entityType = recipe.getEntity();
            BlockPos spawnPos = this.m_58899_().m_7494_();
            if (this.f_58857_ != null && !this.f_58857_.m_5776_() && (level = this.f_58857_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                CompoundTag tag = recipe.getTag();
                Component customName = itemStack.m_41788_() ? itemStack.m_41786_() : null;
                Entity entity = entityType.m_262455_(serverLevel, tag, null, spawnPos, MobSpawnType.TRIGGERED, true, false);
                if (entity != null) {
                    entity.m_6593_(customName);
                    if (this.player != null) {
                        IncubationTrigger.INSTANCE.trigger(this.player, itemStack);
                    }
                }
            }
            itemStack.m_41774_(1);
            return true;
        }
        return false;
    }

    private boolean canIncubate(@Nullable IncubationRecipe recipe, NonNullList<ItemStack> stacks) {
        return !((ItemStack)stacks.get(0)).m_41619_() && recipe != null;
    }

    protected int getBurnDuration(ItemStack fuelStack) {
        if (fuelStack.m_41619_() || !IncubatorBlockEntity.getIncubatingMap().containsKey(fuelStack.m_41720_())) {
            return 0;
        }
        return IncubatorBlockEntity.getIncubatingMap().get(fuelStack.m_41720_());
    }

    private static int getTotalIncubationTime(Level level, IncubatorBlockEntity blockEntity) {
        return blockEntity.quickCheck.m_213657_((Container)blockEntity, level).map(IncubationRecipe::getIncubationTime).orElse(5700);
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    public static Map<Item, Integer> getIncubatingMap() {
        return incubatingMap;
    }

    public static void addItemIncubatingTime(ItemLike itemProvider, int burnTime) {
        Item item = itemProvider.m_5456_();
        IncubatorBlockEntity.getIncubatingMap().put(item, burnTime);
    }

    public static void addItemsIncubatingTime(ItemLike[] itemProviders, int burnTime) {
        Stream.of(itemProviders).map(ItemLike::m_5456_).forEach(item -> IncubatorBlockEntity.getIncubatingMap().put((Item)item, burnTime));
    }

    public static void addItemTagIncubatingTime(TagKey<Item> itemTag, int burnTime) {
        ITagManager tags = ForgeRegistries.ITEMS.tags();
        if (tags != null) {
            tags.getTag(itemTag).stream().forEach(item -> IncubatorBlockEntity.getIncubatingMap().put((Item)item, burnTime));
        }
    }

    public static void removeItemIncubatingTime(ItemLike itemProvider) {
        Item item = itemProvider.m_5456_();
        IncubatorBlockEntity.getIncubatingMap().remove(item);
    }

    public static void removeItemsIncubatingTime(ItemLike[] itemProviders) {
        Stream.of(itemProviders).map(ItemLike::m_5456_).forEach(item -> IncubatorBlockEntity.getIncubatingMap().remove(item));
    }

    public static void removeItemTagIncubatingTime(TagKey<Item> itemTag) {
        ITagManager tags = ForgeRegistries.ITEMS.tags();
        if (tags != null) {
            tags.getTag(itemTag).stream().forEach(item -> IncubatorBlockEntity.getIncubatingMap().remove(item));
        }
    }

    public void setPlayer(ServerPlayer player) {
        this.player = player;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_6836_(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(index);
        boolean flag = !stack.m_41619_() && ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)stack);
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (index == 0 && !flag) {
            this.incubationTotalTime = IncubatorBlockEntity.getTotalIncubationTime(this.f_58857_, this);
            this.incubationProgress = 0;
            this.m_6596_();
        }
    }

    public int m_6643_() {
        return this.items.size();
    }

    public void m_5809_(StackedContents helper) {
        for (ItemStack itemstack : this.items) {
            helper.m_36491_(itemstack);
        }
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            return SLOTS_NS;
        }
        return SLOTS_EW;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index == 1) {
            return this.getBurnDuration(stack) > 0;
        }
        return true;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.m_6423_();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_58395_(Player player, List<ItemStack> items) {
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.m_58899_()) != this) {
            return false;
        }
        return player.m_20275_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5) <= 64.0;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"menu.aether.incubator");
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.litTime = tag.m_128451_("LitTime");
        this.litDuration = this.getBurnDuration((ItemStack)this.items.get(1));
        this.incubationProgress = tag.m_128451_("IncubationProgress");
        this.incubationTotalTime = tag.m_128451_("IncubationTotalTime");
        CompoundTag compoundtag = tag.m_128469_("RecipesUsed");
        for (String string : compoundtag.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(string), compoundtag.m_128451_(string));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("LitTime", this.litTime);
        tag.m_128405_("IncubationProgress", this.incubationProgress);
        tag.m_128405_("IncubationTotalTime", this.incubationTotalTime);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        CompoundTag compoundTag = new CompoundTag();
        this.recipesUsed.forEach((location, integer) -> compoundTag.m_128405_(location.toString(), integer.intValue()));
        tag.m_128365_("RecipesUsed", (Tag)compoundTag);
    }
}

