/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.capability.accessory;

import com.aetherteam.aether.capability.accessory.MobAccessory;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Mob;

public class MobAccessoryCapability
implements MobAccessory {
    private final Mob mob;
    private final Map<String, Float> accessoryDropChances = new HashMap<String, Float>(Map.ofEntries(Map.entry("hands", Float.valueOf(0.085f)), Map.entry("necklace", Float.valueOf(0.085f)), Map.entry("aether_gloves", Float.valueOf(0.085f)), Map.entry("aether_pendant", Float.valueOf(0.085f))));

    public MobAccessoryCapability(Mob mob) {
        this.mob = mob;
    }

    @Override
    public Mob getMob() {
        return this.mob;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        CompoundTag entryTag = new CompoundTag();
        for (Map.Entry<String, Float> entry : this.getAccessoryDropChances().entrySet()) {
            entryTag.m_128350_(entry.getKey(), entry.getValue().floatValue());
        }
        tag.m_128365_("DropChances", (Tag)entryTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_("DropChances")) {
            CompoundTag entryTag = tag.m_128469_("DropChances");
            for (String key : entryTag.m_128431_()) {
                Float value = Float.valueOf(entryTag.m_128457_(key));
                this.getAccessoryDropChances().put(key, value);
            }
        }
    }

    @Override
    public void setGuaranteedDrop(String identifier) {
        if (identifier.equals("hands") || identifier.equals("necklace") || identifier.equals("aether_gloves") || identifier.equals("aether_pendant")) {
            this.getAccessoryDropChances().put(identifier, Float.valueOf(2.0f));
        }
    }

    @Override
    public float getEquipmentDropChance(String identifier) {
        if (identifier.equals("hands") || identifier.equals("necklace") || identifier.equals("aether_gloves") || identifier.equals("aether_pendant")) {
            return this.getAccessoryDropChances().get(identifier).floatValue();
        }
        return 0.0f;
    }

    @Override
    public void setDropChance(String identifier, float chance) {
        if (identifier.equals("hands") || identifier.equals("necklace") || identifier.equals("aether_gloves") || identifier.equals("aether_pendant")) {
            this.getAccessoryDropChances().put(identifier, Float.valueOf(chance));
        }
    }

    @Override
    public Map<String, Float> getAccessoryDropChances() {
        return this.accessoryDropChances;
    }
}

