/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.blockentity;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.dungeon.ChestMimicBlock;
import com.aetherteam.aether.blockentity.ChestMimicBlockEntity;
import com.aetherteam.aether.client.renderer.AetherModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Calendar;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.ModList;
import noobanidus.mods.lootr.config.ConfigManager;

public class ChestMimicRenderer
implements BlockEntityRenderer<ChestMimicBlockEntity> {
    private static final Material LOOTR_MATERIAL = new Material(InventoryMenu.f_39692_, new ResourceLocation("lootr", "chest"));
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private boolean xmasTextures = false;

    public ChestMimicRenderer(BlockEntityRendererProvider.Context context) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.xmasTextures = true;
        }
        ModelPart root = context.m_173582_(AetherModelLayers.CHEST_MIMIC);
        this.bottom = root.m_171324_("bottom");
        this.lid = root.m_171324_("lid");
        this.lock = root.m_171324_("lock");
    }

    public void render(ChestMimicBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockState blockState;
        BlockState blockState2 = blockState = blockEntity.m_58904_() != null ? blockEntity.m_58900_() : (BlockState)((Block)AetherBlocks.CHEST_MIMIC.get()).m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        if (blockState.m_60734_() instanceof ChestMimicBlock) {
            poseStack.m_85836_();
            float f = ((Direction)blockState.m_61143_((Property)ChestBlock.f_51478_)).m_122435_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-f));
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            Material material = this.getMaterial(blockEntity);
            VertexConsumer vertexconsumer = material.m_119194_(buffer, RenderType::m_110452_);
            this.render(poseStack, vertexconsumer, this.lid, this.lock, this.bottom, packedLight, packedOverlay);
            poseStack.m_85849_();
        }
    }

    private void render(PoseStack poseStack, VertexConsumer consumer, ModelPart chestLid, ModelPart chestLatch, ModelPart chestBottom, int packedLight, int packedOverlay) {
        chestLid.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        chestLatch.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        chestBottom.m_104301_(poseStack, consumer, packedLight, packedOverlay);
    }

    private Material getMaterial(ChestMimicBlockEntity blockEntity) {
        if (ModList.get().isLoaded("lootr") && !ConfigManager.isVanillaTextures()) {
            return LOOTR_MATERIAL;
        }
        return Sheets.m_110767_((BlockEntity)blockEntity, (ChestType)ChestType.SINGLE, (boolean)this.xmasTextures);
    }
}

