/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.loot.functions;

import com.aetherteam.aether.loot.functions.AetherLootFunctions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class WhirlwindSpawnEntity
extends LootItemConditionalFunction {
    private final EntityType<?> entityType;
    private final int count;

    protected WhirlwindSpawnEntity(LootItemCondition[] conditions, EntityType<?> entityType, int count) {
        super(conditions);
        this.entityType = entityType;
        this.count = count;
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        ServerLevel serverLevel = context.m_78952_();
        Vec3 originVec = (Vec3)context.m_78953_(LootContextParams.f_81460_);
        if (originVec != null) {
            for (int i = 0; i < this.count; ++i) {
                Entity entity = this.entityType.m_20615_((Level)serverLevel);
                if (entity == null) continue;
                entity.m_7678_(originVec.m_7096_(), originVec.m_7098_() + 0.5, originVec.m_7094_(), (float)Math.random() * 360.0f, 0.0f);
                entity.m_20334_((Math.random() - Math.random()) * 0.125, entity.m_20184_().m_7098_(), (Math.random() - Math.random()) * 0.125);
                serverLevel.m_7967_(entity);
            }
        }
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> builder(EntityType<?> entityType, int count) {
        return LootItemConditionalFunction.m_80683_(lootItemConditions -> new WhirlwindSpawnEntity((LootItemCondition[])lootItemConditions, entityType, count));
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)AetherLootFunctions.WHIRLWIND_SPAWN_ENTITY.get();
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<WhirlwindSpawnEntity> {
        public void serialize(JsonObject json, WhirlwindSpawnEntity instance, JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)instance, context);
            json.addProperty("entity", EntityType.m_20613_(instance.entityType).toString());
            json.addProperty("count", (Number)instance.count);
        }

        public WhirlwindSpawnEntity deserialize(JsonObject json, JsonDeserializationContext context, LootItemCondition[] conditions) {
            EntityType entityType = (EntityType)EntityType.m_20632_((String)GsonHelper.m_13906_((JsonObject)json, (String)"entity")).orElseThrow(() -> new JsonSyntaxException("No value present! Is the loot table entity entry incorrect?"));
            int count = GsonHelper.m_13927_((JsonObject)json, (String)"count");
            return new WhirlwindSpawnEntity(conditions, entityType, count);
        }
    }
}

