/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.clientbound;

import com.aetherteam.aether.perk.data.ClientHaloPerkData;
import com.aetherteam.aether.perk.types.Halo;
import com.aetherteam.nitrogen.network.BasePacket;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class ClientHaloPacket {

    public record Sync(Map<UUID, Halo> halos) implements BasePacket
    {
        public void encode(FriendlyByteBuf buf) {
            buf.m_236831_(this.halos(), FriendlyByteBuf::m_130077_, Halo::write);
        }

        public static Sync decode(FriendlyByteBuf buf) {
            Map halos = buf.m_236847_(FriendlyByteBuf::m_130259_, Halo::read);
            return new Sync(halos);
        }

        public void execute(Player playerEntity) {
            if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91073_ != null && this.halos() != null && !this.halos().isEmpty()) {
                for (Map.Entry<UUID, Halo> haloEntry : this.halos().entrySet()) {
                    ClientHaloPerkData.INSTANCE.applyPerk(haloEntry.getKey(), haloEntry.getValue());
                }
            }
        }
    }

    public record Remove(UUID playerUUID) implements BasePacket
    {
        public void encode(FriendlyByteBuf buf) {
            buf.m_130077_(this.playerUUID());
        }

        public static Remove decode(FriendlyByteBuf buf) {
            UUID uuid = buf.m_130259_();
            return new Remove(uuid);
        }

        public void execute(Player playerEntity) {
            if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91073_ != null && this.playerUUID() != null) {
                ClientHaloPerkData.INSTANCE.removePerk(this.playerUUID());
            }
        }
    }

    public record Apply(UUID playerUUID, Halo halo) implements BasePacket
    {
        public void encode(FriendlyByteBuf buf) {
            buf.m_130077_(this.playerUUID());
            Halo.write(buf, this.halo());
        }

        public static Apply decode(FriendlyByteBuf buf) {
            UUID uuid = buf.m_130259_();
            Halo halo = Halo.read(buf);
            return new Apply(uuid, halo);
        }

        public void execute(Player playerEntity) {
            if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91073_ != null && this.playerUUID() != null && this.halo() != null) {
                ClientHaloPerkData.INSTANCE.applyPerk(this.playerUUID(), this.halo());
            }
        }
    }
}

