/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.perk.data;

import com.aetherteam.aether.perk.types.DeveloperGlow;
import com.aetherteam.aether.perk.types.Halo;
import com.aetherteam.aether.perk.types.MoaData;
import com.aetherteam.aether.perk.types.MoaSkins;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class PerkSavedData
extends SavedData {
    public static final String FILE_NAME = "perks";
    private final Map<UUID, MoaData> storedSkinData = new HashMap<UUID, MoaData>();
    private final Map<UUID, Halo> storedHaloData = new HashMap<UUID, Halo>();
    private final Map<UUID, DeveloperGlow> storedDeveloperGlowData = new HashMap<UUID, DeveloperGlow>();

    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag storedSkinDataTag = new CompoundTag();
        for (Map.Entry<UUID, MoaData> entry : this.storedSkinData.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            if (entry.getValue().moaUUID() != null) {
                compoundTag.m_128362_("MoaUUID", entry.getValue().moaUUID());
            }
            if (entry.getValue().moaSkin() != null) {
                compoundTag.m_128359_("MoaSkin", entry.getValue().moaSkin().getId());
            }
            storedSkinDataTag.m_128365_(entry.getKey().toString(), (Tag)compoundTag);
        }
        tag.m_128365_("StoredSkinData", (Tag)storedSkinDataTag);
        CompoundTag storedHaloDataTag = new CompoundTag();
        for (Map.Entry<UUID, Halo> entry : this.storedHaloData.entrySet()) {
            CompoundTag haloEntryTag = new CompoundTag();
            if (entry.getValue().hexColor() != null) {
                haloEntryTag.m_128359_("HexColor", entry.getValue().hexColor());
            }
            storedHaloDataTag.m_128365_(entry.getKey().toString(), (Tag)haloEntryTag);
        }
        tag.m_128365_("StoredHaloData", (Tag)storedHaloDataTag);
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry<UUID, DeveloperGlow> developerGlowEntry : this.storedDeveloperGlowData.entrySet()) {
            CompoundTag developerGlowTag = new CompoundTag();
            if (developerGlowEntry.getValue().hexColor() != null) {
                developerGlowTag.m_128359_("HexColor", developerGlowEntry.getValue().hexColor());
            }
            compoundTag.m_128365_(developerGlowEntry.getKey().toString(), (Tag)developerGlowTag);
        }
        tag.m_128365_("StoredDeveloperGlowData", (Tag)compoundTag);
        return tag;
    }

    public static PerkSavedData load(CompoundTag tag) {
        PerkSavedData data = PerkSavedData.create();
        for (String key : tag.m_128431_()) {
            String hexColor;
            UUID playerUUID;
            if (key.equals("StoredSkinData")) {
                CompoundTag storedSkinDataTag = tag.m_128469_(key);
                for (String storedSkinDataKey : storedSkinDataTag.m_128431_()) {
                    CompoundTag moaDataEntryTag = storedSkinDataTag.m_128469_(storedSkinDataKey);
                    playerUUID = UUID.fromString(storedSkinDataKey);
                    UUID moaUUID = null;
                    String moaSkinId = null;
                    if (moaDataEntryTag.m_128441_("MoaUUID")) {
                        moaUUID = moaDataEntryTag.m_128342_("MoaUUID");
                    }
                    if (moaDataEntryTag.m_128441_("MoaSkin")) {
                        moaSkinId = moaDataEntryTag.m_128461_("MoaSkin");
                    }
                    MoaSkins.MoaSkin moaSkin = MoaSkins.getMoaSkins().get(moaSkinId);
                    data.storedSkinData.put(playerUUID, new MoaData(moaUUID, moaSkin));
                }
            }
            if (key.equals("StoredHaloData")) {
                CompoundTag storedHaloDataTag = tag.m_128469_(key);
                for (String storedHaloDataKey : storedHaloDataTag.m_128431_()) {
                    CompoundTag haloEntryTag = storedHaloDataTag.m_128469_(storedHaloDataKey);
                    playerUUID = UUID.fromString(storedHaloDataKey);
                    hexColor = null;
                    if (haloEntryTag.m_128441_("HexColor")) {
                        hexColor = haloEntryTag.m_128461_("HexColor");
                    }
                    data.storedHaloData.put(playerUUID, new Halo(hexColor));
                }
            }
            if (!key.equals("StoredDeveloperGlowData")) continue;
            CompoundTag storedDeveloperGlowDataTag = tag.m_128469_(key);
            for (String storedDeveloperGlowDataKey : storedDeveloperGlowDataTag.m_128431_()) {
                CompoundTag developerGlowEntryTag = storedDeveloperGlowDataTag.m_128469_(storedDeveloperGlowDataKey);
                playerUUID = UUID.fromString(storedDeveloperGlowDataKey);
                hexColor = null;
                if (developerGlowEntryTag.m_128441_("HexColor")) {
                    hexColor = developerGlowEntryTag.m_128461_("HexColor");
                }
                data.storedDeveloperGlowData.put(playerUUID, new DeveloperGlow(hexColor));
            }
        }
        return data;
    }

    public static PerkSavedData create() {
        return new PerkSavedData();
    }

    public static PerkSavedData compute(DimensionDataStorage dataStorage) {
        return (PerkSavedData)dataStorage.m_164861_(PerkSavedData::load, PerkSavedData::create, FILE_NAME);
    }

    Map<UUID, MoaData> getStoredSkinData() {
        return ImmutableMap.copyOf(this.storedSkinData);
    }

    void modifyStoredSkinData(UUID uuid, MoaData moaData) {
        this.storedSkinData.put(uuid, moaData);
        this.m_77762_();
    }

    void removeStoredSkinData(UUID uuid) {
        this.storedSkinData.remove(uuid);
        this.m_77762_();
    }

    Map<UUID, Halo> getStoredHaloData() {
        return ImmutableMap.copyOf(this.storedHaloData);
    }

    void modifyStoredHaloData(UUID uuid, Halo halo) {
        this.storedHaloData.put(uuid, halo);
        this.m_77762_();
    }

    void removeStoredHaloData(UUID uuid) {
        this.storedHaloData.remove(uuid);
        this.m_77762_();
    }

    Map<UUID, DeveloperGlow> getStoredDeveloperGlowData() {
        return ImmutableMap.copyOf(this.storedDeveloperGlowData);
    }

    void modifyStoredDeveloperGlowData(UUID uuid, DeveloperGlow developerGlow) {
        this.storedDeveloperGlowData.put(uuid, developerGlow);
        this.m_77762_();
    }

    void removeStoredDeveloperGlowData(UUID uuid) {
        this.storedDeveloperGlowData.remove(uuid);
        this.m_77762_();
    }
}

