/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.serializer;

import com.aetherteam.aether.recipe.recipes.block.AbstractBiomeParameterRecipe;
import com.aetherteam.nitrogen.recipe.BlockPropertyPair;
import com.aetherteam.nitrogen.recipe.BlockStateIngredient;
import com.aetherteam.nitrogen.recipe.BlockStateRecipeUtil;
import com.aetherteam.nitrogen.recipe.serializer.BlockStateRecipeSerializer;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandFunction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeParameterRecipeSerializer<T extends AbstractBiomeParameterRecipe>
extends BlockStateRecipeSerializer<T> {
    private final CookieBaker<T> factory;

    public BiomeParameterRecipeSerializer(CookieBaker<T> factory, BlockStateRecipeSerializer.CookieBaker<T> superFactory) {
        super(superFactory);
        this.factory = factory;
    }

    public T fromJson(ResourceLocation id, JsonObject json) {
        Pair biomeRecipeData = BlockStateRecipeUtil.biomeRecipeDataFromJson((JsonObject)json);
        ResourceKey biomeKey = (ResourceKey)biomeRecipeData.getLeft();
        TagKey biomeTag = (TagKey)biomeRecipeData.getRight();
        AbstractBiomeParameterRecipe recipe = (AbstractBiomeParameterRecipe)super.fromJson(id, json);
        return this.factory.create(id, (ResourceKey<Biome>)biomeKey, (TagKey<Biome>)biomeTag, recipe.getIngredient(), recipe.getResult(), recipe.getFunction());
    }

    @Nullable
    public T fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        ResourceKey biomeKey = BlockStateRecipeUtil.readBiomeKey((FriendlyByteBuf)buffer);
        TagKey biomeTag = BlockStateRecipeUtil.readBiomeTag((FriendlyByteBuf)buffer);
        BlockStateIngredient ingredient = BlockStateIngredient.fromNetwork((FriendlyByteBuf)buffer);
        BlockPropertyPair result = BlockStateRecipeUtil.readPair((FriendlyByteBuf)buffer);
        CommandFunction.CacheableFunction function = BlockStateRecipeUtil.readFunction((FriendlyByteBuf)buffer);
        return this.factory.create(id, (ResourceKey<Biome>)biomeKey, (TagKey<Biome>)biomeTag, ingredient, result, function);
    }

    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        BlockStateRecipeUtil.writeBiomeKey((FriendlyByteBuf)buffer, ((AbstractBiomeParameterRecipe)((Object)recipe)).getBiomeKey());
        BlockStateRecipeUtil.writeBiomeTag((FriendlyByteBuf)buffer, ((AbstractBiomeParameterRecipe)((Object)recipe)).getBiomeTag());
        super.toNetwork(buffer, recipe);
    }

    public static interface CookieBaker<T extends AbstractBiomeParameterRecipe> {
        public T create(ResourceLocation var1, @Nullable ResourceKey<Biome> var2, @Nullable TagKey<Biome> var3, BlockStateIngredient var4, BlockPropertyPair var5, @Nullable CommandFunction.CacheableFunction var6);
    }
}

