/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.serializer;

import com.aetherteam.aether.recipe.recipes.ban.AbstractPlacementBanRecipe;
import com.aetherteam.nitrogen.recipe.BlockStateIngredient;
import com.aetherteam.nitrogen.recipe.BlockStateRecipeUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.biome.Biome;
import org.apache.commons.lang3.tuple.Pair;

public class PlacementBanRecipeSerializer<T, S extends Predicate<T>, F extends AbstractPlacementBanRecipe<T, S>>
implements RecipeSerializer<F> {
    private final CookieBaker<T, S, F> factory;

    public PlacementBanRecipeSerializer(CookieBaker<T, S, F> factory) {
        this.factory = factory;
    }

    public F fromJson(ResourceLocation id, JsonObject json) {
        Pair biomeRecipeData = BlockStateRecipeUtil.biomeRecipeDataFromJson((JsonObject)json);
        ResourceKey biomeKey = (ResourceKey)biomeRecipeData.getLeft();
        TagKey biomeTag = (TagKey)biomeRecipeData.getRight();
        BlockStateIngredient bypassBlock = BlockStateIngredient.EMPTY;
        if (json.has("bypass")) {
            boolean isBypassArray = GsonHelper.m_13885_((JsonObject)json, (String)"bypass");
            JsonArray bypassElement = isBypassArray ? GsonHelper.m_13933_((JsonObject)json, (String)"bypass") : GsonHelper.m_13930_((JsonObject)json, (String)"bypass");
            bypassBlock = BlockStateIngredient.fromJson((JsonElement)bypassElement);
        }
        return this.factory.create(id, (ResourceKey<Biome>)biomeKey, (TagKey<Biome>)biomeTag, bypassBlock);
    }

    @Nullable
    public F fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        ResourceKey biomeKey = BlockStateRecipeUtil.readBiomeKey((FriendlyByteBuf)buffer);
        TagKey biomeTag = BlockStateRecipeUtil.readBiomeTag((FriendlyByteBuf)buffer);
        BlockStateIngredient bypassBlock = BlockStateIngredient.fromNetwork((FriendlyByteBuf)buffer);
        return this.factory.create(id, (ResourceKey<Biome>)biomeKey, (TagKey<Biome>)biomeTag, bypassBlock);
    }

    public void toNetwork(FriendlyByteBuf buffer, F recipe) {
        BlockStateRecipeUtil.writeBiomeKey((FriendlyByteBuf)buffer, ((AbstractPlacementBanRecipe)recipe).getBiomeKey());
        BlockStateRecipeUtil.writeBiomeTag((FriendlyByteBuf)buffer, ((AbstractPlacementBanRecipe)recipe).getBiomeTag());
        ((AbstractPlacementBanRecipe)recipe).getBypassBlock().toNetwork(buffer);
    }

    public static interface CookieBaker<T, S extends Predicate<T>, F extends AbstractPlacementBanRecipe<T, S>> {
        public F create(ResourceLocation var1, @Nullable ResourceKey<Biome> var2, @Nullable TagKey<Biome> var3, BlockStateIngredient var4);
    }
}

