/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.placementmodifier;

import com.aetherteam.aether.world.placementmodifier.AetherPlacementModifiers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class ImprovedLayerPlacementModifier
extends PlacementModifier {
    public static final Codec<ImprovedLayerPlacementModifier> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Heightmap.Types.f_64274_.fieldOf("heightmap").forGetter(modifier -> modifier.heightmap), (App)IntProvider.m_146545_((int)0, (int)256).fieldOf("count").forGetter(modifier -> modifier.count), (App)Codec.INT.optionalFieldOf("verticalBounds", (Object)Integer.MIN_VALUE).forGetter(modifier -> modifier.verticalBounds)).apply((Applicative)codec, ImprovedLayerPlacementModifier::new));
    private final Heightmap.Types heightmap;
    private final IntProvider count;
    private final int verticalBounds;

    private ImprovedLayerPlacementModifier(Heightmap.Types heightmap, IntProvider count, int verticalBounds) {
        this.heightmap = heightmap;
        this.count = count;
        this.verticalBounds = verticalBounds;
    }

    public static ImprovedLayerPlacementModifier of(Heightmap.Types heightmap, IntProvider count, int verticalBounds) {
        return new ImprovedLayerPlacementModifier(heightmap, count, verticalBounds);
    }

    public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos pos) {
        boolean flag;
        Stream.Builder<BlockPos> builder = Stream.builder();
        int i = 0;
        do {
            flag = false;
            for (int j = 0; j < this.count.m_214085_(random); ++j) {
                int z;
                int height;
                int x = random.m_188503_(16) + pos.m_123341_();
                BlockPos blockPos = this.findOnGroundPosition(context, new BlockPos(x, height = context.m_191824_(this.heightmap, x, z = random.m_188503_(16) + pos.m_123343_()), z), i);
                if (blockPos == null) continue;
                builder.add(blockPos);
                flag = true;
            }
            ++i;
        } while (flag);
        return builder.build();
    }

    public PlacementModifierType<?> m_183327_() {
        return AetherPlacementModifiers.IMPROVED_LAYER_PLACEMENT;
    }

    @Nullable
    private BlockPos findOnGroundPosition(PlacementContext context, BlockPos pos, int count) {
        int y;
        int i = 0;
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        for (int j = y = pos.m_123342_(); j >= context.m_191830_() + 1; --j) {
            BlockPos blockPos = new BlockPos(x, j, z);
            BlockState blockState = context.m_191828_(blockPos);
            BlockState belowState = context.m_191828_(blockPos.m_7495_());
            if (!blockState.m_60795_() || !this.isSolid(belowState) || belowState.m_60713_(Blocks.f_50752_) || !this.checkVerticalBounds(context, blockPos)) continue;
            if (i == count) {
                return blockPos;
            }
            ++i;
        }
        return null;
    }

    private boolean checkVerticalBounds(PlacementContext context, BlockPos pos) {
        int i = pos.m_123341_();
        int j = pos.m_123343_();
        int k = pos.m_123342_();
        boolean flag = true;
        for (int y = k; y < k + this.verticalBounds; ++y) {
            BlockPos blockPos = new BlockPos(i, y, j);
            if (!this.isSolid(context.m_191828_(blockPos))) continue;
            flag = false;
        }
        return flag;
    }

    private boolean isSolid(BlockState state) {
        return !state.m_60795_() && !state.m_60713_(Blocks.f_49990_) && !state.m_60713_(Blocks.f_49991_);
    }
}

