/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.bedrockore;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.worldgen.BiomeWeightModifier;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.utils.RegistryUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class BedrockOreDefinition {
    public static final MapCodec<Pair<Material, Integer>> MATERIAL = Codec.mapPair((MapCodec)GTCEuAPI.materialManager.codec().fieldOf("material"), (MapCodec)Codec.INT.fieldOf("chance"));
    public static final Codec<BedrockOreDefinition> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("weight").forGetter(ft -> ft.weight), (App)Codec.INT.fieldOf("size").forGetter(ft -> ft.size), (App)IntProvider.f_146533_.fieldOf("yield").forGetter(ft -> ft.yield), (App)Codec.INT.fieldOf("depletion_amount").forGetter(ft -> ft.depletionAmount), (App)ExtraCodecs.m_269197_((int)0, (int)100).fieldOf("depletion_chance").forGetter(ft -> ft.depletionChance), (App)Codec.INT.fieldOf("depleted_yield").forGetter(ft -> ft.depletedYield), (App)MATERIAL.codec().listOf().fieldOf("materials").forGetter(ft -> ft.materials), (App)BiomeWeightModifier.CODEC.listOf().optionalFieldOf("weight_modifier", List.of()).forGetter(ft -> ft.originalModifiers), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).listOf().fieldOf("dimension_filter").forGetter(ft -> new ArrayList<ResourceKey<Level>>(ft.dimensionFilter))).apply((Applicative)instance, (weight, size, yield, depletionAmount, depletionChance, depletedYield, materials, biomeWeightModifier, dimensionFilter) -> new BedrockOreDefinition((int)weight, (int)size, (IntProvider)yield, (int)depletionAmount, (int)depletionChance, (int)depletedYield, (List<Pair<Material, Integer>>)materials, (List<BiomeWeightModifier>)biomeWeightModifier, (Set<ResourceKey<Level>>)new HashSet<ResourceKey<Level>>((Collection<ResourceKey<Level>>)dimensionFilter))));
    private int weight;
    private int size;
    private IntProvider yield;
    private int depletionAmount;
    private int depletionChance;
    private int depletedYield;
    private List<Pair<Material, Integer>> materials;
    private BiomeWeightModifier biomeWeightModifier;
    private List<BiomeWeightModifier> originalModifiers;
    public Set<ResourceKey<Level>> dimensionFilter;

    public BedrockOreDefinition(ResourceLocation name, int size, int weight, IntProvider yield, int depletionAmount, int depletionChance, int depletedYield, List<Pair<Material, Integer>> materials, List<BiomeWeightModifier> originalModifiers, Set<ResourceKey<Level>> dimensionFilter) {
        this(weight, size, yield, depletionAmount, depletionChance, depletedYield, materials, originalModifiers, dimensionFilter);
        GTRegistries.BEDROCK_ORE_DEFINITIONS.register(name, this);
    }

    public BedrockOreDefinition(int weight, int size, IntProvider yield, int depletionAmount, int depletionChance, int depletedYield, List<Pair<Material, Integer>> materials, final List<BiomeWeightModifier> originalModifiers, Set<ResourceKey<Level>> dimensionFilter) {
        this.weight = weight;
        this.size = size;
        this.yield = yield;
        this.depletionAmount = depletionAmount;
        this.depletionChance = depletionChance;
        this.depletedYield = depletedYield;
        this.materials = materials;
        this.originalModifiers = originalModifiers;
        this.biomeWeightModifier = new BiomeWeightModifier(() -> HolderSet.m_205800_(originalModifiers.stream().flatMap(mod -> mod.biomes.get().m_203614_()).toList()), originalModifiers.stream().mapToInt(mod -> mod.addedWeight).sum()){

            @Override
            public Integer apply(Holder<Biome> biome) {
                int mod = 0;
                for (BiomeWeightModifier modifier : originalModifiers) {
                    if (!modifier.biomes.get().m_203333_(biome)) continue;
                    mod += modifier.apply(biome).intValue();
                }
                return mod;
            }
        };
        this.dimensionFilter = dimensionFilter;
    }

    public void setOriginalModifiers(List<BiomeWeightModifier> modifiers) {
        this.originalModifiers = modifiers;
        this.biomeWeightModifier = new BiomeWeightModifier(() -> HolderSet.m_205800_(this.originalModifiers.stream().flatMap(mod -> mod.biomes.get().m_203614_()).toList()), this.originalModifiers.stream().mapToInt(mod -> mod.addedWeight).sum()){

            @Override
            public Integer apply(Holder<Biome> biome) {
                int mod = 0;
                for (BiomeWeightModifier modifier : BedrockOreDefinition.this.originalModifiers) {
                    if (!modifier.biomes.get().m_203333_(biome)) continue;
                    mod += modifier.apply(biome).intValue();
                }
                return mod;
            }
        };
    }

    public static Builder builder(ResourceLocation name) {
        return new Builder(name);
    }

    public int weight() {
        return this.weight;
    }

    public BedrockOreDefinition weight(int weight) {
        this.weight = weight;
        return this;
    }

    public int size() {
        return this.size;
    }

    public BedrockOreDefinition size(int size) {
        this.size = size;
        return this;
    }

    public IntProvider yield() {
        return this.yield;
    }

    public BedrockOreDefinition yield(IntProvider yield) {
        this.yield = yield;
        return this;
    }

    public int depletionAmount() {
        return this.depletionAmount;
    }

    public BedrockOreDefinition depletionAmount(int depletionAmount) {
        this.depletionAmount = depletionAmount;
        return this;
    }

    public int depletionChance() {
        return this.depletionChance;
    }

    public BedrockOreDefinition depletionChance(int depletionChance) {
        this.depletionChance = depletionChance;
        return this;
    }

    public int depletedYield() {
        return this.depletedYield;
    }

    public BedrockOreDefinition depletedYield(int depletedYield) {
        this.depletedYield = depletedYield;
        return this;
    }

    public List<Pair<Material, Integer>> materials() {
        return this.materials;
    }

    public BedrockOreDefinition materials(List<Pair<Material, Integer>> materials) {
        this.materials = materials;
        return this;
    }

    public BiomeWeightModifier biomeWeightModifier() {
        return this.biomeWeightModifier;
    }

    public Set<ResourceKey<Level>> dimensionFilter() {
        return this.dimensionFilter;
    }

    public BedrockOreDefinition dimensionFilter(Set<ResourceKey<Level>> dimensionFilter) {
        this.dimensionFilter = dimensionFilter;
        return this;
    }

    public static class Builder {
        private final ResourceLocation name;
        private int weight;
        private int size;
        private IntProvider yield;
        private int depletionAmount;
        private int depletionChance = 1;
        private int depletedYield;
        private List<Pair<Material, Integer>> materials;
        private Set<ResourceKey<Level>> dimensions;
        private final List<BiomeWeightModifier> biomes = new LinkedList<BiomeWeightModifier>();

        private Builder(ResourceLocation name) {
            this.name = name;
        }

        public Builder copy(ResourceLocation name) {
            Builder copied = new Builder(name);
            copied.weight = this.weight;
            copied.yield = this.yield;
            copied.depletionAmount = this.depletionAmount;
            copied.depletionChance = this.depletionChance;
            copied.depletedYield = this.depletedYield;
            copied.materials = this.materials;
            return copied;
        }

        public Builder material(Material material, int amount) {
            if (this.materials == null) {
                this.materials = new ArrayList<Pair<Material, Integer>>();
            }
            this.materials.add((Pair<Material, Integer>)Pair.of((Object)material, (Object)amount));
            return this;
        }

        public Builder yield(int min, int max) {
            return this.yield((IntProvider)UniformInt.m_146622_((int)min, (int)max));
        }

        public Builder biomes(int weight, TagKey<Biome> biomes) {
            this.biomes.add(new BiomeWeightModifier(() -> GTRegistries.builtinRegistry().m_175515_(Registries.f_256952_).m_203561_(biomes), weight));
            return this;
        }

        @SafeVarargs
        public final Builder biomes(int weight, ResourceKey<Biome> ... biomes) {
            this.biomes.add(new BiomeWeightModifier(() -> HolderSet.m_205806_(arg_0 -> ((Registry)GTRegistries.builtinRegistry().m_175515_(Registries.f_256952_)).m_246971_(arg_0), (Object[])biomes), weight));
            return this;
        }

        public Builder biomes(int weight, HolderSet<Biome> biomes) {
            this.biomes.add(new BiomeWeightModifier(() -> biomes, weight));
            return this;
        }

        @HideFromJS
        public Builder dimensions(Set<ResourceKey<Level>> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder dimensions(String ... dimensions) {
            return this.dimensions(new HashSet<ResourceKey<Level>>(RegistryUtil.resolveResourceKeys(Registries.f_256858_, dimensions)));
        }

        public BedrockOreDefinition register() {
            BedrockOreDefinition definition = new BedrockOreDefinition(this.weight, this.size, this.yield, this.depletionAmount, this.depletionChance, this.depletedYield, this.materials, this.biomes, this.dimensions);
            GTRegistries.BEDROCK_ORE_DEFINITIONS.registerOrOverride(this.name, definition);
            return definition;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder yield(IntProvider yield) {
            this.yield = yield;
            return this;
        }

        public Builder depletionAmount(int depletionAmount) {
            this.depletionAmount = depletionAmount;
            return this;
        }

        public Builder depletionChance(int depletionChance) {
            this.depletionChance = depletionChance;
            return this;
        }

        public Builder depletedYield(int depletedYield) {
            this.depletedYield = depletedYield;
            return this;
        }

        public Builder materials(List<Pair<Material, Integer>> materials) {
            this.materials = materials;
            return this;
        }
    }
}

