/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator.veins;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreVeinUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import org.jetbrains.annotations.NotNull;

public class CuboidVeinGenerator
extends VeinGenerator {
    public static final Codec<Either<List<OreConfiguration.TargetBlockState>, Material>> LAYER_CODEC = Codec.either((Codec)OreConfiguration.TargetBlockState.f_161031_.listOf(), GTCEuAPI.materialManager.codec());
    public static final Codec<CuboidVeinGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LAYER_CODEC.fieldOf("top").forGetter(val -> val.top), (App)LAYER_CODEC.fieldOf("middle").forGetter(val -> val.middle), (App)LAYER_CODEC.fieldOf("bottom").forGetter(val -> val.bottom), (App)LAYER_CODEC.fieldOf("spread").forGetter(val -> val.spread), (App)Codec.INT.fieldOf("min_y").forGetter(val -> val.minY), (App)Codec.INT.fieldOf("max_y").forGetter(val -> val.maxY)).apply((Applicative)instance, CuboidVeinGenerator::new));
    private Either<List<OreConfiguration.TargetBlockState>, Material> top;
    private Either<List<OreConfiguration.TargetBlockState>, Material> middle;
    private Either<List<OreConfiguration.TargetBlockState>, Material> bottom;
    private Either<List<OreConfiguration.TargetBlockState>, Material> spread;
    private int minY;
    private int maxY;

    public CuboidVeinGenerator(GTOreDefinition entry) {
        super(entry);
    }

    @Override
    public List<Map.Entry<Either<BlockState, Material>, Integer>> getAllEntries() {
        ArrayList<Map.Entry<Either<BlockState, Material>, Integer>> result = new ArrayList<Map.Entry<Either<BlockState, Material>, Integer>>();
        ((Stream)this.top.map(blockStates -> blockStates.stream().map(state -> Either.left((Object)state.f_161033_)), material -> Stream.of(Either.right((Object)material)))).forEach(entry -> result.add(Map.entry(entry, 2)));
        ((Stream)this.middle.map(blockStates -> blockStates.stream().map(state -> Either.left((Object)state.f_161033_)), material -> Stream.of(Either.right((Object)material)))).forEach(entry -> result.add(Map.entry(entry, 3)));
        ((Stream)this.bottom.map(blockStates -> blockStates.stream().map(state -> Either.left((Object)state.f_161033_)), material -> Stream.of(Either.right((Object)material)))).forEach(entry -> result.add(Map.entry(entry, 4)));
        ((Stream)this.spread.map(blockStates -> blockStates.stream().map(state -> Either.left((Object)state.f_161033_)), material -> Stream.of(Either.right((Object)material)))).forEach(entry -> result.add(Map.entry(entry, 7)));
        return result;
    }

    @Override
    public Map<BlockPos, OreBlockPlacer> generate(WorldGenLevel level, RandomSource random, GTOreDefinition entry, BlockPos origin) {
        Object2ObjectOpenHashMap generatedBlocks = new Object2ObjectOpenHashMap();
        int size = entry.clusterSize().m_214085_(random);
        int westBound = origin.m_123341_() - random.m_188503_(size);
        int eastBound = origin.m_123341_() + random.m_188503_(size);
        int northBound = origin.m_123343_() - random.m_188503_(size);
        int southBound = origin.m_123343_() + random.m_188503_(size);
        int minY = this.minY;
        int startY = minY + random.m_188503_(this.maxY - minY - 5);
        int topAmount = 0;
        int middleAmount = 0;
        int bottomAmount = 0;
        int spreadAmount = 0;
        for (int layerOffset = -1; layerOffset <= 7; ++layerOffset) {
            int layer = startY + layerOffset;
            if (level.m_151562_(layer)) continue;
            for (int x = westBound; x < eastBound; ++x) {
                for (int z = northBound; z < southBound; ++z) {
                    long randomSeed = random.m_188505_();
                    double xLength = origin.m_123341_() - x;
                    double zLength = origin.m_123343_() - z;
                    double volume = Math.sqrt(2.0 + xLength * xLength + zLength * zLength);
                    int localDensity = (int)Math.max(1.0, (double)entry.density() * volume);
                    int weightX = Math.max(1, Math.max(Mth.m_14040_((int)(westBound - x)), Mth.m_14040_((int)(eastBound - x))) / localDensity);
                    int weightZ = Math.max(1, Math.max(Mth.m_14040_((int)(southBound - z)), Mth.m_14040_((int)(northBound - z))) / localDensity);
                    BlockPos pos = new BlockPos(x, layer, z);
                    if (layerOffset <= 1) {
                        if (this.placeBottom((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ)) {
                            ++bottomAmount;
                            continue;
                        }
                        if (!this.placeSpread((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ)) continue;
                        ++spreadAmount;
                        continue;
                    }
                    if (layerOffset == 2) {
                        if (this.placeMiddle((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ)) {
                            ++middleAmount;
                            continue;
                        }
                        if (this.placeBottom((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ)) {
                            ++bottomAmount;
                            continue;
                        }
                        if (!this.placeSpread((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ)) continue;
                        ++spreadAmount;
                        continue;
                    }
                    if (layerOffset == 3) {
                        if (this.placeMiddle((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ)) {
                            ++middleAmount;
                            continue;
                        }
                        if (!this.placeSpread((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ)) continue;
                        ++spreadAmount;
                        continue;
                    }
                    if (layerOffset <= 5) {
                        if (this.placeMiddle((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ)) {
                            ++middleAmount;
                            continue;
                        }
                        if (this.placeTop((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ)) {
                            ++topAmount;
                            continue;
                        }
                        if (!this.placeSpread((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ)) continue;
                        ++spreadAmount;
                        continue;
                    }
                    if (this.placeTop((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ)) {
                        ++topAmount;
                        continue;
                    }
                    if (!this.placeSpread((Map<BlockPos, OreBlockPlacer>)generatedBlocks, entry, randomSeed, pos, random, weightX, weightZ)) continue;
                    ++spreadAmount;
                }
            }
        }
        return generatedBlocks;
    }

    protected static boolean shouldPlaceOre(@NotNull RandomSource random, int weightX, int weightZ) {
        return random.m_188503_(weightX) == 0 || random.m_188503_(weightZ) == 0;
    }

    private boolean placeTop(Map<BlockPos, OreBlockPlacer> generatedBlocks, GTOreDefinition entry, long randomSeed, BlockPos pos, RandomSource random, int weightX, int weightZ) {
        Either<List<OreConfiguration.TargetBlockState>, Material> top = this.top;
        if (CuboidVeinGenerator.shouldPlaceOre(random, weightX, weightZ)) {
            generatedBlocks.put(pos, (access, section) -> this.placeOre(access, section, pos, randomSeed, top, entry));
            return true;
        }
        return false;
    }

    private boolean placeMiddle(Map<BlockPos, OreBlockPlacer> generatedBlocks, GTOreDefinition entry, long randomSeed, BlockPos pos, RandomSource random, int weightX, int weightZ) {
        Either<List<OreConfiguration.TargetBlockState>, Material> middle = this.middle;
        if (random.m_188503_(2) == 0 && CuboidVeinGenerator.shouldPlaceOre(random, weightX, weightZ)) {
            generatedBlocks.put(pos, (access, section) -> this.placeOre(access, section, pos, randomSeed, middle, entry));
            return true;
        }
        return false;
    }

    private boolean placeBottom(Map<BlockPos, OreBlockPlacer> generatedBlocks, GTOreDefinition entry, long randomSeed, BlockPos pos, RandomSource random, int weightX, int weightZ) {
        Either<List<OreConfiguration.TargetBlockState>, Material> bottom = this.bottom;
        if (CuboidVeinGenerator.shouldPlaceOre(random, weightX, weightZ)) {
            generatedBlocks.put(pos, (access, section) -> this.placeOre(access, section, pos, randomSeed, bottom, entry));
            return true;
        }
        return false;
    }

    private boolean placeSpread(Map<BlockPos, OreBlockPlacer> generatedBlocks, GTOreDefinition entry, long randomSeed, BlockPos pos, RandomSource random, int weightX, int weightZ) {
        Either<List<OreConfiguration.TargetBlockState>, Material> spread = this.spread;
        if (random.m_188503_(7) == 0 && CuboidVeinGenerator.shouldPlaceOre(random, weightX, weightZ)) {
            generatedBlocks.put(pos, (access, section) -> this.placeOre(access, section, pos, randomSeed, spread, entry));
            return true;
        }
        return false;
    }

    public void placeOre(BulkSectionAccess access, LevelChunkSection section, BlockPos pos, long randomSeed, Either<List<OreConfiguration.TargetBlockState>, Material> ore, GTOreDefinition entry) {
        XoroshiroRandomSource random = new XoroshiroRandomSource(randomSeed);
        int x = SectionPos.m_123207_((int)pos.m_123341_());
        int y = SectionPos.m_123207_((int)pos.m_123342_());
        int z = SectionPos.m_123207_((int)pos.m_123343_());
        BlockState existing = section.m_62982_(x, y, z);
        ore.ifLeft(arg_0 -> CuboidVeinGenerator.lambda$placeOre$27(existing, access, (RandomSource)random, entry, pos, section, x, y, z, arg_0)).ifRight(arg_0 -> CuboidVeinGenerator.lambda$placeOre$28(existing, access, (RandomSource)random, entry, pos, section, x, y, z, arg_0));
    }

    @Override
    public VeinGenerator build() {
        return null;
    }

    @Override
    public VeinGenerator copy() {
        return null;
    }

    @Override
    public Codec<? extends VeinGenerator> codec() {
        return null;
    }

    public CuboidVeinGenerator(Either<List<OreConfiguration.TargetBlockState>, Material> top, Either<List<OreConfiguration.TargetBlockState>, Material> middle, Either<List<OreConfiguration.TargetBlockState>, Material> bottom, Either<List<OreConfiguration.TargetBlockState>, Material> spread, int minY, int maxY) {
        this.top = top;
        this.middle = middle;
        this.bottom = bottom;
        this.spread = spread;
        this.minY = minY;
        this.maxY = maxY;
    }

    private static /* synthetic */ void lambda$placeOre$28(BlockState existing, BulkSectionAccess access, RandomSource random, GTOreDefinition entry, BlockPos pos, LevelChunkSection section, int x, int y, int z, Material material) {
        if (!OreVeinUtil.canPlaceOre(existing, arg_0 -> ((BulkSectionAccess)access).m_156110_(arg_0), random, entry, pos)) {
            return;
        }
        BlockState currentState = access.m_156110_(pos);
        Optional<TagPrefix> prefix = ChemicalHelper.getOrePrefix(currentState);
        if (prefix.isEmpty()) {
            return;
        }
        Block toPlace = ChemicalHelper.getBlock(prefix.get(), material);
        if (toPlace == null || toPlace.m_49966_().m_60795_()) {
            return;
        }
        section.m_62991_(x, y, z, toPlace.m_49966_(), false);
    }

    private static /* synthetic */ void lambda$placeOre$27(BlockState existing, BulkSectionAccess access, RandomSource random, GTOreDefinition entry, BlockPos pos, LevelChunkSection section, int x, int y, int z, List blockStates) {
        for (OreConfiguration.TargetBlockState targetState : blockStates) {
            if (!OreVeinUtil.canPlaceOre(existing, arg_0 -> ((BulkSectionAccess)access).m_156110_(arg_0), random, entry, targetState, pos) || targetState.f_161033_.m_60795_()) continue;
            section.m_62991_(x, y, z, targetState.f_161033_, false);
            break;
        }
    }
}

