/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.fancy;

import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.gui.fancy.TabsWidget;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VerticalTabsWidget
extends TabsWidget {
    public VerticalTabsWidget(Consumer<IFancyUIProvider> onTabClick, int x, int y, int width, int height) {
        super(onTabClick, x, y, width, height);
        ResourceTexture tabsLeft = new ResourceTexture("gtceu:textures/gui/tab/tabs_left.png");
        this.setTabTexture((IGuiTexture)tabsLeft.getSubTexture(0.0f, 0.33333334f, 0.5f, 0.33333334f));
        this.setTabHoverTexture((IGuiTexture)tabsLeft.getSubTexture(0.5f, 0.33333334f, 0.5f, 0.33333334f));
        this.setTabPressedTexture((IGuiTexture)tabsLeft.getSubTexture(0.5f, 0.33333334f, 0.5f, 0.33333334f));
    }

    @Override
    public boolean hasButton() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawBackgroundTexture(graphics, mouseX, mouseY);
        Position position = this.getPosition();
        Size size = this.getSize();
        IFancyUIProvider hoveredTab = this.getHoveredTab(mouseX, mouseY);
        this.drawTab(this.mainTab, graphics, mouseX, mouseY, position.x, position.y + 8, 24, 24, hoveredTab);
        for (int i = 0; i < this.subTabs.size(); ++i) {
            this.drawTab((IFancyUIProvider)this.subTabs.get(i), graphics, mouseX, mouseY, position.x, position.y + 8 + 24 * (i + 1), 24, 24, hoveredTab);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public IFancyUIProvider getHoveredTab(double mouseX, double mouseY) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            Position position = this.getPosition();
            Size size = this.getSize();
            if (VerticalTabsWidget.isMouseOver((int)position.x, (int)(position.y + 8), (int)24, (int)24, (double)mouseX, (double)mouseY)) {
                return this.mainTab;
            }
            int i = ((int)mouseY - position.y - 24 - 8) / 24;
            if (i >= 0 && i < this.subTabs.size()) {
                return (IFancyUIProvider)this.subTabs.get(i);
            }
        }
        return null;
    }
}

