/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.util;

import java.util.function.DoubleSupplier;

public class TimedProgressSupplier
implements DoubleSupplier {
    private final int msPerCycle;
    private final int maxValue;
    private final boolean countDown;
    private long startTime;

    public TimedProgressSupplier(int ticksPerCycle, int maxValue, boolean countDown) {
        this.msPerCycle = ticksPerCycle * 50;
        this.maxValue = maxValue;
        this.countDown = countDown;
        this.startTime = System.currentTimeMillis();
    }

    public void resetCountdown() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public double getAsDouble() {
        return this.calculateTime();
    }

    private double calculateTime() {
        long currentTime = System.currentTimeMillis();
        long msPassed = (currentTime - this.startTime) % (long)this.msPerCycle;
        double currentValue = 1.0 * (double)msPassed * (double)this.maxValue / (double)this.msPerCycle;
        if (this.countDown) {
            return ((double)this.maxValue - currentValue) / (double)this.maxValue;
        }
        return currentValue / (double)this.maxValue;
    }
}

