/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.misc.PacketProspecting;
import com.gregtechceu.gtceu.api.gui.misc.ProspectorMode;
import com.gregtechceu.gtceu.api.gui.texture.ProspectingTexture;
import com.gregtechceu.gtceu.api.item.IComponentItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.common.item.ProspectorScannerBehavior;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SearchComponentWidget;
import com.lowdragmc.lowdraglib.gui.widget.SelectableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ProspectingMapWidget
extends WidgetGroup
implements SearchComponentWidget.IWidgetSearch<Object> {
    private final int chunkRadius;
    private final ProspectorMode mode;
    private final int scanTick;
    private boolean darkMode = false;
    private final DraggableScrollableWidgetGroup itemList;
    @OnlyIn(value=Dist.CLIENT)
    private ProspectingTexture texture;
    private int playerChunkX;
    private int playerChunkZ;
    private int chunkIndex = 0;
    private final Queue<PacketProspecting> packetQueue = new LinkedBlockingQueue<PacketProspecting>();
    private final Set<Object> items = new CopyOnWriteArraySet<Object>();
    private final Map<String, SelectableWidgetGroup> selectedMap = new ConcurrentHashMap<String, SelectableWidgetGroup>();

    public ProspectingMapWidget(int xPosition, int yPosition, int width, int height, int chunkRadius, @NotNull ProspectorMode mode, int scanTick) {
        super(xPosition, yPosition, width, height);
        this.chunkRadius = chunkRadius;
        this.mode = mode;
        this.scanTick = scanTick;
        int imageWidth = (chunkRadius * 2 - 1) * 16;
        int imageHeight = (chunkRadius * 2 - 1) * 16;
        this.addWidget((Widget)new ImageWidget(0, (height - imageHeight) / 2 - 4, imageWidth + 8, imageHeight + 8, (IGuiTexture)GuiTextures.BACKGROUND_INVERSE));
        WidgetGroup group = (WidgetGroup)new WidgetGroup(imageWidth + 10, 0, width - (imageWidth + 10), height).setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        this.itemList = new DraggableScrollableWidgetGroup(4, 28, group.getSize().width - 8, group.getSize().height - 32).setYScrollBarWidth(2).setYBarStyle(null, (IGuiTexture)ColorPattern.T_WHITE.rectTexture().setRadius(1.0f));
        group.addWidget((Widget)this.itemList);
        group.addWidget((Widget)new SearchComponentWidget(6, 6, group.getSize().width - 12, 18, (SearchComponentWidget.IWidgetSearch)this));
        this.addWidget((Widget)group);
        this.addNewItem("[all]", "all resources", IGuiTexture.EMPTY, -1);
    }

    public void writeInitialData(FriendlyByteBuf buffer) {
        super.writeInitialData(buffer);
        this.playerChunkX = this.gui.entityPlayer.m_146902_().f_45578_;
        buffer.m_130130_(this.playerChunkX);
        this.playerChunkZ = this.gui.entityPlayer.m_146902_().f_45579_;
        buffer.m_130130_(this.playerChunkZ);
        buffer.m_130130_(this.gui.entityPlayer.m_146903_());
        buffer.m_130130_(this.gui.entityPlayer.m_146907_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readInitialData(FriendlyByteBuf buffer) {
        super.readInitialData(buffer);
        this.texture = new ProspectingTexture(buffer.m_130242_(), buffer.m_130242_(), buffer.m_130242_(), buffer.m_130242_(), this.gui.entityPlayer.m_213816_(), this.mode, this.chunkRadius, this.darkMode);
    }

    public void setDarkMode(boolean mode) {
        if (this.darkMode != mode) {
            this.darkMode = mode;
            if (this.isRemote()) {
                this.texture.setDarkMode(this.darkMode);
            }
        }
    }

    private void addOresToList(Object[][][] data) {
        HashSet<Object> newItems = new HashSet<Object>();
        for (int x = 0; x < this.mode.cellSize; ++x) {
            for (int z = 0; z < this.mode.cellSize; ++z) {
                for (Object item : data[x][z]) {
                    newItems.add(item);
                    this.addNewItem(this.mode.getUniqueID(item), this.mode.getDescriptionId(item), this.mode.getItemIcon(item), this.mode.getItemColor(item));
                }
            }
        }
        this.items.addAll(newItems);
    }

    private void addNewItem(String uniqueID, String renderingName, IGuiTexture icon, int color) {
        if (!this.selectedMap.containsKey(uniqueID)) {
            int index = this.itemList.widgets.size();
            SelectableWidgetGroup selectableWidgetGroup = new SelectableWidgetGroup(0, index * 15, this.itemList.getSize().width - 4, 15);
            Size size = selectableWidgetGroup.getSize();
            selectableWidgetGroup.addWidget((Widget)new ImageWidget(0, 0, 15, 15, icon));
            selectableWidgetGroup.addWidget((Widget)new ImageWidget(15, 0, size.width - 15, 15, (IGuiTexture)new TextTexture(renderingName).setWidth(size.width - 15).setType(TextTexture.TextType.LEFT_HIDE)));
            selectableWidgetGroup.setOnSelected(s -> {
                if (this.isRemote()) {
                    this.texture.setSelected(uniqueID);
                }
            });
            selectableWidgetGroup.setSelectedTexture((IGuiTexture)ColorPattern.WHITE.borderTexture(-1));
            this.itemList.addWidget((Widget)selectableWidgetGroup);
            this.selectedMap.put(uniqueID, selectableWidgetGroup);
        }
    }

    public void detectAndSendChanges() {
        ItemStack held;
        Object object;
        Player player = this.gui.entityPlayer;
        Level world = player.m_9236_();
        if (this.gui.getTickCount() % (long)this.scanTick == 0L && this.chunkIndex < (this.chunkRadius * 2 - 1) * (this.chunkRadius * 2 - 1)) {
            int row = this.chunkIndex / (this.chunkRadius * 2 - 1);
            int column = this.chunkIndex % (this.chunkRadius * 2 - 1);
            int ox = column - this.chunkRadius + 1;
            int oz = row - this.chunkRadius + 1;
            LevelChunk chunk = world.m_6325_(this.playerChunkX + ox, this.playerChunkZ + oz);
            PacketProspecting packet = new PacketProspecting(this.playerChunkX + ox, this.playerChunkZ + oz, this.mode);
            this.mode.scan(packet.data, chunk);
            this.writeUpdateInfo(-1, packet::writePacketData);
            ++this.chunkIndex;
        }
        if ((object = (held = player.m_21120_(InteractionHand.MAIN_HAND)).m_41720_()) instanceof IComponentItem) {
            IComponentItem componentItem = (IComponentItem)object;
            for (IItemComponent component : componentItem.getComponents()) {
                if (!(component instanceof ProspectorScannerBehavior)) continue;
                ProspectorScannerBehavior prospector = (ProspectorScannerBehavior)component;
                if (player.m_7500_() || prospector.drainEnergy(held, false)) continue;
                player.m_6915_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        if (id == -1) {
            this.addPacketToQueue(PacketProspecting.readPacketData(this.mode, buffer));
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        if (this.packetQueue != null) {
            int max = 10;
            while (max-- > 0 && !this.packetQueue.isEmpty()) {
                PacketProspecting packet = this.packetQueue.poll();
                this.texture.updateTexture(packet);
                this.addOresToList(packet.data);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addPacketToQueue(PacketProspecting packet) {
        this.packetQueue.add(packet);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Position position = this.getPosition();
        Size size = this.getSize();
        int x = position.x + 3;
        int y = position.y + (size.getHeight() - this.texture.getImageHeight()) / 2 - 1;
        this.texture.draw(graphics, x, y);
        int cX = (mouseX - x) / 16;
        int cZ = (mouseY - y) / 16;
        if (cX >= 0 && cZ >= 0 && cX < this.chunkRadius * 2 - 1 && cZ < this.chunkRadius * 2 - 1) {
            DrawerHelper.drawSolidRect((GuiGraphics)graphics, (int)(cX * 16 + x), (int)(cZ * 16 + y), (int)16, (int)16, (int)1265396844);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        Position position = this.getPosition();
        Size size = this.getSize();
        int x = position.x + 3;
        int y = position.y + (size.getHeight() - this.texture.getImageHeight()) / 2 - 1;
        int cX = (mouseX - x) / 16;
        int cZ = (mouseY - y) / 16;
        if (cX >= 0 && cZ >= 0 && cX < this.chunkRadius * 2 - 1 && cZ < this.chunkRadius * 2 - 1) {
            ArrayList<Component> tooltips = new ArrayList<Component>();
            tooltips.add((Component)Component.m_237115_((String)this.mode.unlocalizedName));
            ArrayList<T[]> items = new ArrayList<T[]>();
            for (int i = 0; i < this.mode.cellSize; ++i) {
                for (int j = 0; j < this.mode.cellSize; ++j) {
                    assert (this.texture != null);
                    if (this.texture.data[cX * this.mode.cellSize + i][cZ * this.mode.cellSize + j] == null) continue;
                    items.add(this.texture.data[cX * this.mode.cellSize + i][cZ * this.mode.cellSize + j]);
                }
            }
            this.mode.appendTooltips(items, tooltips, this.texture.getSelected());
            this.gui.getModularUIGui().setHoverTooltip(tooltips, ItemStack.f_41583_, null, null);
        }
    }

    public String resultDisplay(Object value) {
        return this.mode.getDescriptionId(value);
    }

    public void selectResult(Object item) {
        if (this.isRemote()) {
            String uid = this.mode.getUniqueID(item);
            this.texture.setSelected(uid);
            SelectableWidgetGroup selected = this.selectedMap.get(uid);
            if (selected != null) {
                this.itemList.setSelected((Widget)selected);
            }
        }
    }

    public void search(String s, Consumer<Object> consumer) {
        HashSet<String> added = new HashSet<String>();
        for (Object item : this.items) {
            String id = this.mode.getUniqueID(item);
            if (added.contains(id)) continue;
            added.add(id);
            String localized = LocalizationUtils.format((String)this.resultDisplay(item), (Object[])new Object[0]);
            if (!item.toString().toLowerCase(Locale.ROOT).contains(s.toLowerCase(Locale.ROOT)) && !localized.toLowerCase(Locale.ROOT).contains(s.toLowerCase(Locale.ROOT))) continue;
            consumer.accept(item);
        }
    }

    public boolean isDarkMode() {
        return this.darkMode;
    }
}

