/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.widget.PhantomFluidWidget;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ScrollablePhantomFluidWidget
extends PhantomFluidWidget {
    private static final int SCROLL_ACTION_ID = 65537;
    private static final long MILLIBUCKETS = FluidHelper.getBucket() / 1000L;

    public ScrollablePhantomFluidWidget(@Nullable IFluidTransfer fluidTank, int tank, int x, int y, int width, int height, Supplier<FluidStack> phantomFluidGetter, Consumer<FluidStack> phantomFluidSetter) {
        super(fluidTank, tank, x, y, width, height, phantomFluidGetter, phantomFluidSetter);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        if (!this.isMouseOverElement(mouseX, mouseY)) {
            return false;
        }
        long delta = this.getModifiedChangeAmount(wheelDelta > 0.0 ? 1 : -1) * MILLIBUCKETS;
        this.writeClientAction(65537, buf -> buf.writeLong(delta));
        return true;
    }

    private long getModifiedChangeAmount(int amount) {
        if (GTUtil.isShiftDown()) {
            amount *= 10;
        }
        if (GTUtil.isCtrlDown()) {
            amount *= 100;
        }
        if (!GTUtil.isAltDown()) {
            amount *= 1000;
        }
        return amount;
    }

    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        switch (id) {
            case 65537: {
                this.handleScrollAction(buffer.readLong());
                break;
            }
            default: {
                super.handleClientAction(id, buffer);
            }
        }
        this.detectAndSendChanges();
    }

    private void handleScrollAction(long delta) {
        IFluidTransfer fluidTank = this.getFluidTank();
        if (fluidTank == null) {
            return;
        }
        FluidStack fluid = fluidTank.getFluidInTank(this.tank);
        if (fluid.isEmpty()) {
            return;
        }
        if (fluid.isEmpty()) {
            return;
        }
        fluid.setAmount(Math.min(Math.max(fluid.getAmount() + delta, 0L), fluidTank.getTankCapacity(this.tank)));
        if (fluid.getAmount() <= 0L) {
            fluidTank.setFluidInTank(this.tank, FluidStack.empty());
        }
    }
}

