/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.fancyconfigurator;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;

public class FancyTankConfigurator
implements IFancyConfigurator {
    private final FluidStorage[] tanks;
    private final Component title;
    private List<Component> tooltips = Collections.emptyList();

    public FancyTankConfigurator(FluidStorage[] tanks, Component title) {
        this.tanks = tanks;
        this.title = title;
    }

    @Override
    public IGuiTexture getIcon() {
        return GuiTextures.BUTTON_FLUID_OUTPUT;
    }

    @Override
    public Widget createConfigurator() {
        int rowSize;
        int colSize = rowSize = (int)Math.sqrt(this.tanks.length);
        if (this.tanks.length == 8) {
            rowSize = 4;
            colSize = 2;
        }
        WidgetGroup group = new WidgetGroup(0, 0, 18 * rowSize + 16, 18 * colSize + 16);
        WidgetGroup container = new WidgetGroup(4, 4, 18 * rowSize + 8, 18 * colSize + 8);
        int index = 0;
        for (int y = 0; y < colSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                container.addWidget((Widget)new TankWidget((IFluidStorage)this.tanks[index++], 4 + x * 18, 4 + y * 18, true, true).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT));
            }
        }
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)container);
        return group;
    }

    @Override
    public Component getTitle() {
        return this.title;
    }

    @Override
    public List<Component> getTooltips() {
        return this.tooltips;
    }

    public FancyTankConfigurator setTooltips(List<Component> tooltips) {
        this.tooltips = tooltips;
        return this;
    }
}

