/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.feature;

import com.gregtechceu.gtceu.api.capability.ICleanroomReceiver;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineFeature;
import com.gregtechceu.gtceu.api.machine.feature.IMufflableMachine;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.IVoidable;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.config.ConfigHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IRecipeLogicMachine
extends IRecipeCapabilityHolder,
IMachineFeature,
IWorkable,
ICleanroomReceiver,
IVoidable {
    @Override
    default public int getChanceTier() {
        int n;
        MetaMachine metaMachine = this.self();
        if (metaMachine instanceof ITieredMachine) {
            ITieredMachine tieredMachine = (ITieredMachine)((Object)metaMachine);
            n = tieredMachine.getTier();
        } else {
            n = this.self().getDefinition().getTier();
        }
        return n;
    }

    @NotNull
    public GTRecipeType[] getRecipeTypes();

    @NotNull
    public GTRecipeType getRecipeType();

    public int getActiveRecipeType();

    public void setActiveRecipeType(int var1);

    default public void notifyStatusChanged(RecipeLogic.Status oldStatus, RecipeLogic.Status newStatus) {
    }

    @NotNull
    public RecipeLogic getRecipeLogic();

    default public GTRecipe fullModifyRecipe(GTRecipe recipe) {
        return this.doModifyRecipe(recipe.trimRecipeOutputs(this.getOutputLimits()));
    }

    @Nullable
    default public GTRecipe doModifyRecipe(GTRecipe recipe) {
        return this.self().getDefinition().getRecipeModifier().apply(this.self(), recipe);
    }

    default public boolean keepSubscribing() {
        return true;
    }

    default public boolean isRecipeLogicAvailable() {
        return true;
    }

    default public boolean beforeWorking(@Nullable GTRecipe recipe) {
        return this.self().getDefinition().getBeforeWorking().test(this, recipe);
    }

    default public boolean onWorking() {
        return this.self().getDefinition().getOnWorking().test(this);
    }

    default public void onWaiting() {
        this.self().getDefinition().getOnWaiting().accept(this);
    }

    default public void afterWorking() {
        this.self().getDefinition().getAfterWorking().accept(this);
    }

    default public boolean dampingWhenWaiting() {
        return true;
    }

    default public boolean alwaysTryModifyRecipe() {
        return true;
    }

    default public boolean shouldWorkingPlaySound() {
        IMufflableMachine mufflableMachine;
        MetaMachine metaMachine;
        return ConfigHolder.INSTANCE.machines.machineSounds && (!((metaMachine = this.self()) instanceof IMufflableMachine) || !(mufflableMachine = (IMufflableMachine)((Object)metaMachine)).isMuffled());
    }

    @Override
    default public boolean isWorkingEnabled() {
        return this.getRecipeLogic().isWorkingEnabled();
    }

    @Override
    default public void setWorkingEnabled(boolean isWorkingAllowed) {
        this.getRecipeLogic().setWorkingEnabled(isWorkingAllowed);
    }

    @Override
    default public int getProgress() {
        return this.getRecipeLogic().getProgress();
    }

    @Override
    default public int getMaxProgress() {
        return this.getRecipeLogic().getMaxProgress();
    }

    @Override
    default public boolean isActive() {
        return this.getRecipeLogic().isActive();
    }
}

