/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.steam;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.ICleanroomProvider;
import com.gregtechceu.gtceu.api.machine.feature.IMufflableMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamMachine;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class SteamWorkableMachine
extends SteamMachine
implements IRecipeLogicMachine,
IMufflableMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(SteamWorkableMachine.class, SteamMachine.MANAGED_FIELD_HOLDER);
    @Nullable
    private ICleanroomProvider cleanroom;
    @Persisted
    @DescSynced
    public final RecipeLogic recipeLogic;
    public final GTRecipeType[] recipeTypes = this.getDefinition().getRecipeTypes();
    public int activeRecipeType = 0;
    @Persisted
    @DescSynced
    @RequireRerender
    protected Direction outputFacing;
    @Persisted
    @DescSynced
    protected boolean isMuffled;
    protected boolean previouslyMuffled = true;
    protected final Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> capabilitiesProxy;
    protected final List<ISubscription> traitSubscriptions;

    public SteamWorkableMachine(IMachineBlockEntity holder, boolean isHighPressure, Object ... args) {
        super(holder, isHighPressure, args);
        this.recipeLogic = this.createRecipeLogic(args);
        this.capabilitiesProxy = Tables.newCustomTable(new EnumMap(IO.class), IdentityHashMap::new);
        this.traitSubscriptions = new ArrayList<ISubscription>();
        this.outputFacing = this.hasFrontFacing() ? this.getFrontFacing().m_122424_() : Direction.UP;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        for (MachineTrait trait : this.getTraits()) {
            List handlers;
            if (!(trait instanceof IRecipeHandlerTrait)) continue;
            IRecipeHandlerTrait handlerTrait = (IRecipeHandlerTrait)((Object)trait);
            if (!this.capabilitiesProxy.contains((Object)handlerTrait.getHandlerIO(), handlerTrait.getCapability())) {
                this.capabilitiesProxy.put((Object)handlerTrait.getHandlerIO(), handlerTrait.getCapability(), new ArrayList());
            }
            if ((handlers = (List)this.capabilitiesProxy.get((Object)handlerTrait.getHandlerIO(), handlerTrait.getCapability())) != null) {
                handlers.add(handlerTrait);
            }
            this.traitSubscriptions.add(handlerTrait.addChangedListener(this.recipeLogic::updateTickSubscription));
        }
    }

    protected RecipeLogic createRecipeLogic(Object ... args) {
        return new RecipeLogic(this);
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.traitSubscriptions.forEach(ISubscription::unsubscribe);
        this.traitSubscriptions.clear();
        this.recipeLogic.inValid();
    }

    public void setOutputFacing(@NotNull Direction outputFacing) {
        if (!this.hasFrontFacing() || this.outputFacing != this.getFrontFacing()) {
            this.outputFacing = outputFacing;
        }
    }

    @Override
    protected InteractionResult onWrenchClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!playerIn.m_6144_() && !this.isRemote()) {
            if (this.hasFrontFacing() && gridSide == this.getFrontFacing()) {
                return InteractionResult.PASS;
            }
            this.setOutputFacing(gridSide);
            return InteractionResult.CONSUME;
        }
        return super.onWrenchClick(playerIn, hand, gridSide, hitResult);
    }

    @Override
    public boolean keepSubscribing() {
        return false;
    }

    @Override
    @NotNull
    public GTRecipeType getRecipeType() {
        return this.recipeTypes[this.activeRecipeType];
    }

    @Override
    public void clientTick() {
        super.clientTick();
        if (this.previouslyMuffled != this.isMuffled) {
            this.previouslyMuffled = this.isMuffled;
            if (this.recipeLogic != null) {
                this.recipeLogic.updateSound();
            }
        }
    }

    @Override
    public ResourceTexture sideTips(Player player, Set<GTToolType> toolTypes, Direction side) {
        if (!(!toolTypes.contains(GTToolType.WRENCH) || player.m_6144_() || this.hasFrontFacing() && side == this.getFrontFacing())) {
            return GuiTextures.TOOL_IO_FACING_ROTATION;
        }
        return super.sideTips(player, toolTypes, side);
    }

    @Override
    @Nullable
    public ICleanroomProvider getCleanroom() {
        return this.cleanroom;
    }

    @Override
    public void setCleanroom(@Nullable ICleanroomProvider cleanroom) {
        this.cleanroom = cleanroom;
    }

    @Override
    public RecipeLogic getRecipeLogic() {
        return this.recipeLogic;
    }

    @Override
    public GTRecipeType[] getRecipeTypes() {
        return this.recipeTypes;
    }

    @Override
    public int getActiveRecipeType() {
        return this.activeRecipeType;
    }

    @Override
    public void setActiveRecipeType(int activeRecipeType) {
        this.activeRecipeType = activeRecipeType;
    }

    public Direction getOutputFacing() {
        return this.outputFacing;
    }

    @Override
    public boolean isMuffled() {
        return this.isMuffled;
    }

    @Override
    public void setMuffled(boolean isMuffled) {
        this.isMuffled = isMuffled;
    }

    @Override
    public Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> getCapabilitiesProxy() {
        return this.capabilitiesProxy;
    }
}

