/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.ICapabilityTrait;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidTankProxyTrait
extends MachineTrait
implements IFluidTransfer,
ICapabilityTrait {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(FluidTankProxyTrait.class);
    public final IO capabilityIO;
    @Nullable
    public IFluidTransfer proxy;

    public FluidTankProxyTrait(MetaMachine machine, IO capabilityIO) {
        super(machine);
        this.capabilityIO = capabilityIO;
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onContentsChanged() {
        if (this.proxy != null) {
            this.proxy.onContentsChanged();
        }
    }

    public int getTanks() {
        return this.proxy == null ? 0 : this.proxy.getTanks();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.proxy == null ? FluidStack.empty() : this.proxy.getFluidInTank(tank);
    }

    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        if (this.proxy != null) {
            this.proxy.setFluidInTank(tank, fluidStack);
        }
    }

    public long getTankCapacity(int tank) {
        return this.proxy == null ? 0L : this.proxy.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.proxy != null && this.proxy.isFluidValid(tank, stack);
    }

    public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        if (this.proxy != null && this.canCapInput()) {
            return this.proxy.fill(tank, resource, simulate, notifyChanges);
        }
        return 0L;
    }

    public long fill(FluidStack resource, boolean simulate, boolean notifyChanges) {
        if (this.proxy != null && this.canCapInput()) {
            return this.proxy.fill(resource, simulate, notifyChanges);
        }
        return 0L;
    }

    public long fillInternal(FluidStack resource, boolean simulate) {
        if (this.proxy != null && !resource.isEmpty()) {
            return this.proxy.fill(resource, simulate);
        }
        return 0L;
    }

    @NotNull
    public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        if (this.proxy != null && this.canCapOutput()) {
            return this.proxy.drain(tank, resource, simulate, notifyChanges);
        }
        return FluidStack.empty();
    }

    public FluidStack drainInternal(FluidStack resource, boolean simulate) {
        if (this.proxy != null && !resource.isEmpty()) {
            return this.proxy.drain(resource, simulate);
        }
        return FluidStack.empty();
    }

    @NotNull
    public FluidStack drain(long maxDrain, boolean simulate, boolean notifyChanges) {
        if (this.proxy != null && this.canCapOutput()) {
            return this.proxy.drain(maxDrain, simulate, notifyChanges);
        }
        return FluidStack.empty();
    }

    @NotNull
    public FluidStack drain(FluidStack resource, boolean simulate, boolean notifyChanges) {
        if (this.proxy != null && this.canCapOutput()) {
            return this.proxy.drain(resource, simulate, notifyChanges);
        }
        return FluidStack.empty();
    }

    @NotNull
    public Object createSnapshot() {
        return this.proxy == null ? new Object() : this.proxy.createSnapshot();
    }

    public void restoreFromSnapshot(Object snapshot) {
        if (this.proxy != null) {
            this.proxy.restoreFromSnapshot(snapshot);
        }
    }

    public FluidStack drainInternal(long maxDrain, boolean simulate) {
        return this.proxy == null ? FluidStack.empty() : this.proxy.drain(maxDrain, simulate);
    }

    public boolean supportsFill(int i) {
        return this.canCapInput();
    }

    public boolean supportsDrain(int i) {
        return this.canCapOutput();
    }

    public boolean isEmpty() {
        IFluidTransfer iFluidTransfer = this.proxy;
        if (iFluidTransfer instanceof NotifiableFluidTank) {
            NotifiableFluidTank fluidTank = (NotifiableFluidTank)iFluidTransfer;
            return fluidTank.isEmpty();
        }
        boolean isEmpty = true;
        if (this.proxy != null) {
            for (int i = 0; i < this.proxy.getTanks(); ++i) {
                if (this.proxy.getFluidInTank(i).isEmpty()) continue;
                isEmpty = false;
                break;
            }
        }
        return isEmpty;
    }

    public void exportToNearby(Direction ... facings) {
        if (this.isEmpty()) {
            return;
        }
        Level level = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        for (Direction facing : facings) {
            FluidTransferHelper.exportToTarget((IFluidTransfer)this, (int)Integer.MAX_VALUE, f -> true, (Level)level, (BlockPos)pos.m_121945_(facing), (Direction)facing.m_122424_());
        }
    }

    @Override
    public IO getCapabilityIO() {
        return this.capabilityIO;
    }

    public FluidTankProxyTrait setProxy(@Nullable IFluidTransfer proxy) {
        this.proxy = proxy;
        return this;
    }

    @Nullable
    public IFluidTransfer getProxy() {
        return this.proxy;
    }
}

