/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.ICapabilityTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotifiableFluidTank
extends NotifiableRecipeHandlerTrait<FluidIngredient>
implements ICapabilityTrait,
IFluidTransfer {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(NotifiableFluidTank.class, NotifiableRecipeHandlerTrait.MANAGED_FIELD_HOLDER);
    public final IO handlerIO;
    public final IO capabilityIO;
    @Persisted
    private final FluidStorage[] storages;
    protected boolean allowSameFluids;
    private Boolean isEmpty;
    @Persisted
    @DescSynced
    protected FluidStorage lockedFluid = new FluidStorage(FluidHelper.getBucket());

    public NotifiableFluidTank(MetaMachine machine, int slots, long capacity, IO io, IO capabilityIO) {
        super(machine);
        this.handlerIO = io;
        this.storages = new FluidStorage[slots];
        this.capabilityIO = capabilityIO;
        for (int i = 0; i < this.storages.length; ++i) {
            this.storages[i] = new FluidStorage(capacity);
            this.storages[i].setOnContentsChanged(this::onContentsChanged);
        }
    }

    public NotifiableFluidTank(MetaMachine machine, List<FluidStorage> storages, IO io, IO capabilityIO) {
        super(machine);
        this.handlerIO = io;
        this.storages = (FluidStorage[])storages.toArray(FluidStorage[]::new);
        this.capabilityIO = capabilityIO;
        for (FluidStorage storage : this.getStorages()) {
            storage.setOnContentsChanged(this::onContentsChanged);
        }
        if (io == IO.IN) {
            this.allowSameFluids = true;
        }
    }

    public NotifiableFluidTank(MetaMachine machine, int slots, long capacity, IO io) {
        this(machine, slots, capacity, io, io);
    }

    public NotifiableFluidTank(MetaMachine machine, List<FluidStorage> storages, IO io) {
        this(machine, storages, io, io);
    }

    public void onContentsChanged() {
        this.isEmpty = null;
        this.notifyListeners();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public List<FluidIngredient> handleRecipeInner(IO io, GTRecipe recipe, List<FluidIngredient> left, @Nullable String slotName, boolean simulate) {
        return NotifiableFluidTank.handleIngredient(io, recipe, left, simulate, this.handlerIO, this.storages);
    }

    @Nullable
    public static List<FluidIngredient> handleIngredient(IO io, GTRecipe recipe, List<FluidIngredient> left, boolean simulate, IO handlerIO, FluidStorage[] storages) {
        FluidStorage[] capabilities;
        if (io != handlerIO) {
            return left;
        }
        for (FluidStorage capability : capabilities = simulate ? (FluidStorage[])Arrays.stream(storages).map(FluidStorage::copy).toArray(FluidStorage[]::new) : storages) {
            Iterator<FluidIngredient> iterator = left.iterator();
            if (io == IO.IN) {
                while (iterator.hasNext()) {
                    fluidStack = iterator.next();
                    if (fluidStack.isEmpty()) {
                        iterator.remove();
                        continue;
                    }
                    boolean found = false;
                    FluidStack foundStack = null;
                    for (int i = 0; i < capability.getTanks(); ++i) {
                        FluidStack stored = capability.getFluidInTank(i);
                        if (!fluidStack.test(stored)) continue;
                        found = true;
                        foundStack = stored;
                    }
                    if (!found) continue;
                    FluidStack drained = capability.drain(foundStack.copy(fluidStack.getAmount()), false);
                    fluidStack.setAmount(fluidStack.getAmount() - drained.getAmount());
                    if (fluidStack.getAmount() > 0L) continue;
                    iterator.remove();
                }
            } else if (io == IO.OUT) {
                while (iterator.hasNext()) {
                    fluidStack = iterator.next();
                    if (fluidStack.isEmpty()) {
                        iterator.remove();
                        continue;
                    }
                    FluidStack[] fluids = fluidStack.getStacks();
                    if (fluids.length == 0) {
                        iterator.remove();
                        continue;
                    }
                    FluidStack output = fluids[0];
                    long filled = capability.fill(output.copy(), false);
                    if (!fluidStack.isEmpty()) {
                        fluidStack.setAmount(fluidStack.getAmount() - filled);
                    }
                    if (fluidStack.getAmount() > 0L) continue;
                    iterator.remove();
                }
            }
            if (left.isEmpty()) break;
        }
        return left.isEmpty() ? null : left;
    }

    @Override
    public boolean test(FluidIngredient ingredient) {
        return !this.isLocked() || ingredient.test(this.lockedFluid.getFluid());
    }

    @Override
    public int getPriority() {
        return !this.isLocked() || this.lockedFluid.getFluid().isEmpty() ? super.getPriority() : 0x3FFFFFFF - this.getTanks();
    }

    public boolean isLocked() {
        return !this.lockedFluid.getFluid().isEmpty();
    }

    public void setLocked(boolean locked) {
        if (this.isLocked() == locked) {
            return;
        }
        FluidStack fluidStack = this.getStorages()[0].getFluid();
        if (locked && !fluidStack.isEmpty()) {
            this.lockedFluid.setFluid(fluidStack.copy());
            this.lockedFluid.getFluid().setAmount(1L);
            this.onContentsChanged();
            this.setFilter(stack -> stack.isFluidEqual(this.lockedFluid.getFluid()));
        } else {
            this.lockedFluid.setFluid(FluidStack.empty());
            this.setFilter(stack -> true);
            this.onContentsChanged();
        }
    }

    public void setLocked(boolean locked, FluidStack fluidStack) {
        if (this.isLocked() == locked) {
            return;
        }
        if (locked && !fluidStack.isEmpty()) {
            this.lockedFluid.setFluid(fluidStack.copy());
            this.lockedFluid.getFluid().setAmount(1L);
            this.onContentsChanged();
            this.setFilter(stack -> stack.isFluidEqual(this.lockedFluid.getFluid()));
        } else {
            this.lockedFluid.setFluid(FluidStack.empty());
            this.setFilter(stack -> true);
            this.onContentsChanged();
        }
    }

    public NotifiableFluidTank setFilter(Predicate<FluidStack> filter) {
        for (FluidStorage storage : this.getStorages()) {
            storage.setValidator(filter);
        }
        return this;
    }

    @Override
    public RecipeCapability<FluidIngredient> getCapability() {
        return FluidRecipeCapability.CAP;
    }

    public int getTanks() {
        return this.getStorages().length;
    }

    @Override
    public int getSize() {
        return this.getTanks();
    }

    @Override
    public List<Object> getContents() {
        ArrayList<FluidStack> ingredients = new ArrayList<FluidStack>();
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack stack = this.getFluidInTank(i);
            if (stack.isEmpty()) continue;
            ingredients.add(stack);
        }
        return Arrays.asList(ingredients.toArray());
    }

    @Override
    public double getTotalContentAmount() {
        long amount = 0L;
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack stack = this.getFluidInTank(i);
            if (stack.isEmpty()) continue;
            amount += stack.getAmount();
        }
        return amount;
    }

    public boolean isEmpty() {
        if (this.isEmpty == null) {
            this.isEmpty = true;
            for (FluidStorage storage : this.getStorages()) {
                if (storage.getFluid().isEmpty()) continue;
                this.isEmpty = false;
                break;
            }
        }
        return this.isEmpty;
    }

    public void exportToNearby(Direction ... facings) {
        if (this.isEmpty()) {
            return;
        }
        Level level = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        for (Direction facing : facings) {
            FluidTransferHelper.exportToTarget((IFluidTransfer)this, (int)Integer.MAX_VALUE, f -> true, (Level)level, (BlockPos)pos.m_121945_(facing), (Direction)facing.m_122424_());
        }
    }

    public void importFromNearby(Direction ... facings) {
        Level level = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        for (Direction facing : facings) {
            FluidTransferHelper.importToTarget((IFluidTransfer)this, (int)Integer.MAX_VALUE, f -> true, (Level)level, (BlockPos)pos.m_121945_(facing), (Direction)facing.m_122424_());
        }
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.getStorages()[tank].getFluid();
    }

    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        this.getStorages()[tank].setFluid(fluidStack);
    }

    public long getTankCapacity(int tank) {
        return this.getStorages()[tank].getCapacity();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.getStorages()[tank].isFluidValid(stack);
    }

    public long fill(FluidStack resource, boolean simulate, boolean notifyChanges) {
        if (resource.isEmpty() || !this.canCapInput()) {
            return 0L;
        }
        long filled = 0L;
        FluidStorage existingStorage = null;
        if (!this.allowSameFluids) {
            for (FluidStorage storage : this.getStorages()) {
                if (storage.getFluid().isEmpty() || !storage.getFluid().isFluidEqual(resource)) continue;
                existingStorage = storage;
                break;
            }
        }
        if (existingStorage == null) {
            for (int i = 0; i < this.getTanks() && (filled <= 0L || this.allowSameFluids) && (filled += this.fill(i, resource.copy(resource.getAmount() - filled), simulate, notifyChanges)) != resource.getAmount(); ++i) {
            }
        } else {
            filled += existingStorage.fill(resource.copy(resource.getAmount() - filled), simulate, notifyChanges);
        }
        if (notifyChanges && filled > 0L && !simulate) {
            this.onContentsChanged();
        }
        return filled;
    }

    public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        if (tank >= 0 && tank < this.getStorages().length && this.canCapInput()) {
            return this.getStorages()[tank].fill(resource, simulate, notifyChanges);
        }
        return 0L;
    }

    public long fill(FluidStack resource, boolean simulate) {
        if (this.canCapInput()) {
            return this.fillInternal(resource, simulate);
        }
        return 0L;
    }

    public long fillInternal(FluidStack resource, boolean simulate) {
        if (resource.isEmpty()) {
            return 0L;
        }
        FluidStack copied = resource.copy();
        FluidStorage existingStorage = null;
        if (!this.allowSameFluids) {
            for (FluidStorage storage : this.getStorages()) {
                if (storage.getFluid().isEmpty() || !storage.getFluid().isFluidEqual(resource)) continue;
                existingStorage = storage;
                break;
            }
        }
        if (existingStorage == null) {
            for (FluidStorage storage : this.getStorages()) {
                long filled = storage.fill(copied.copy(), simulate);
                if (filled > 0L) {
                    copied.shrink(filled);
                    if (!this.allowSameFluids) break;
                }
                if (!copied.isEmpty()) {
                    continue;
                }
                break;
            }
        } else {
            copied.shrink(existingStorage.fill(copied.copy(), simulate));
        }
        return resource.getAmount() - copied.getAmount();
    }

    @NotNull
    public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        if (tank >= 0 && tank < this.getStorages().length && this.canCapOutput()) {
            return this.getStorages()[tank].drain(resource, simulate, notifyChanges);
        }
        return FluidStack.empty();
    }

    @NotNull
    public FluidStack drain(FluidStack resource, boolean simulate) {
        if (this.canCapOutput()) {
            return this.drainInternal(resource, simulate);
        }
        return FluidStack.empty();
    }

    public FluidStack drainInternal(FluidStack resource, boolean simulate) {
        if (!resource.isEmpty()) {
            FluidStack copied = resource.copy();
            for (FluidStorage transfer : this.getStorages()) {
                FluidStack candidate = copied.copy();
                copied.shrink(transfer.drain(candidate, simulate).getAmount());
                if (copied.isEmpty()) break;
            }
            copied.setAmount(resource.getAmount() - copied.getAmount());
            return copied;
        }
        return FluidStack.empty();
    }

    @NotNull
    public FluidStack drain(long maxDrain, boolean simulate) {
        if (this.canCapOutput()) {
            return this.drainInternal(maxDrain, simulate);
        }
        return FluidStack.empty();
    }

    public FluidStack drainInternal(long maxDrain, boolean simulate) {
        if (maxDrain == 0L) {
            return FluidStack.empty();
        }
        FluidStack totalDrained = null;
        for (FluidStorage storage : this.getStorages()) {
            if (totalDrained == null || totalDrained.isEmpty()) {
                totalDrained = storage.drain(maxDrain, simulate);
                if (totalDrained.isEmpty()) {
                    totalDrained = null;
                } else {
                    maxDrain -= totalDrained.getAmount();
                }
            } else {
                FluidStack copy = totalDrained.copy();
                copy.setAmount(maxDrain);
                FluidStack drain = storage.drain(copy, simulate);
                totalDrained.grow(drain.getAmount());
                maxDrain -= drain.getAmount();
            }
            if (maxDrain <= 0L) break;
        }
        return totalDrained == null ? FluidStack.empty() : totalDrained;
    }

    public boolean supportsFill(int i) {
        return this.canCapInput();
    }

    public boolean supportsDrain(int i) {
        return this.canCapOutput();
    }

    @Override
    public void onMachineLoad() {
        super.onMachineLoad();
        if (this.isLocked()) {
            this.setFilter(stack -> stack.isFluidEqual(this.lockedFluid.getFluid()));
        }
    }

    @NotNull
    public Object createSnapshot() {
        return Arrays.stream(this.getStorages()).map(IFluidTransfer::createSnapshot).toArray(Object[]::new);
    }

    public void restoreFromSnapshot(Object snapshot) {
        Object[] array;
        if (snapshot instanceof Object[] && (array = (Object[])snapshot).length == this.getStorages().length) {
            for (int i = 0; i < array.length; ++i) {
                this.getStorages()[i].restoreFromSnapshot(array[i]);
            }
        }
    }

    @Override
    public IO getHandlerIO() {
        return this.handlerIO;
    }

    @Override
    public IO getCapabilityIO() {
        return this.capabilityIO;
    }

    public FluidStorage[] getStorages() {
        return this.storages;
    }

    public void setAllowSameFluids(boolean allowSameFluids) {
        this.allowSameFluids = allowSameFluids;
    }

    public FluidStorage getLockedFluid() {
        return this.lockedFluid;
    }
}

