/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.ICapabilityTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.recipe.DummyCraftingContainer;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotifiableItemStackHandler
extends NotifiableRecipeHandlerTrait<Ingredient>
implements ICapabilityTrait,
IItemTransfer {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(NotifiableItemStackHandler.class, NotifiableRecipeHandlerTrait.MANAGED_FIELD_HOLDER);
    public final IO handlerIO;
    public final IO capabilityIO;
    @Persisted
    @DescSynced
    public final ItemStackTransfer storage;
    private Boolean isEmpty;

    public NotifiableItemStackHandler(MetaMachine machine, int slots, @NotNull IO handlerIO, @NotNull IO capabilityIO, Function<Integer, ItemStackTransfer> transferFactory) {
        super(machine);
        this.handlerIO = handlerIO;
        this.storage = transferFactory.apply(slots);
        this.capabilityIO = capabilityIO;
        this.storage.setOnContentsChanged(this::onContentsChanged);
    }

    public NotifiableItemStackHandler(MetaMachine machine, int slots, @NotNull IO handlerIO, @NotNull IO capabilityIO) {
        this(machine, slots, handlerIO, capabilityIO, ItemStackTransfer::new);
    }

    public NotifiableItemStackHandler(MetaMachine machine, int slots, @NotNull IO handlerIO) {
        this(machine, slots, handlerIO, handlerIO);
    }

    public NotifiableItemStackHandler setFilter(Function<ItemStack, Boolean> filter) {
        this.storage.setFilter(filter);
        return this;
    }

    public void onContentsChanged() {
        this.isEmpty = null;
        this.notifyListeners();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public List<Ingredient> handleRecipeInner(IO io, GTRecipe recipe, List<Ingredient> left, @Nullable String slotName, boolean simulate) {
        return NotifiableItemStackHandler.handleIngredient(io, recipe, left, simulate, this.handlerIO, this.storage);
    }

    @Nullable
    public static List<Ingredient> handleIngredient(IO io, GTRecipe recipe, List<Ingredient> left, boolean simulate, IO handlerIO, ItemStackTransfer storage) {
        block14: {
            Iterator<Ingredient> iterator;
            ItemStackTransfer capability;
            block13: {
                if (io != handlerIO) {
                    return left;
                }
                capability = simulate ? storage.copy() : storage;
                iterator = left.iterator();
                if (io != IO.IN) break block13;
                block0: while (iterator.hasNext()) {
                    Ingredient ingredient = iterator.next();
                    for (int i = 0; i < capability.getSlots(); ++i) {
                        ItemStack[] ingredientStacks;
                        ItemStack itemStack = capability.getStackInSlot(i);
                        if (!ingredient.test(itemStack)) continue;
                        for (ItemStack ingredientStack : ingredientStacks = ingredient.m_43908_()) {
                            ItemStack actioned;
                            if (!ingredientStack.m_150930_(itemStack.m_41720_())) continue;
                            ItemStack extracted = ItemStack.f_41583_;
                            boolean didRunIngredientAction = false;
                            if (GTCEu.isKubeJSLoaded() && !(actioned = KJSCallWrapper.applyIngredientAction(capability, i, recipe.ingredientActions)).m_41619_()) {
                                extracted = actioned;
                                didRunIngredientAction = true;
                            }
                            if (!didRunIngredientAction) {
                                extracted = capability.extractItem(i, ingredientStack.m_41613_(), false);
                            }
                            ingredientStack.m_41764_(ingredientStack.m_41613_() - extracted.m_41613_());
                            if (!ingredientStack.m_41619_()) continue;
                            iterator.remove();
                            continue block0;
                        }
                    }
                }
                break block14;
            }
            if (io != IO.OUT) break block14;
            while (iterator.hasNext()) {
                ItemStack[] items;
                Ingredient ingredient = iterator.next();
                if (ingredient instanceof IntProviderIngredient) {
                    IntProviderIngredient intProvider = (IntProviderIngredient)ingredient;
                    intProvider.setItemStacks(null);
                    intProvider.setSampledCount(null);
                }
                if ((items = ingredient.m_43908_()).length == 0) {
                    iterator.remove();
                    continue;
                }
                ItemStack output = items[0];
                if (!output.m_41619_()) {
                    for (int i = 0; i < capability.getSlots(); ++i) {
                        ItemStack actioned;
                        ItemStack leftStack = ItemStack.f_41583_;
                        boolean didRunIngredientAction = false;
                        if (GTCEu.isKubeJSLoaded() && !(actioned = KJSCallWrapper.applyIngredientAction(capability, i, recipe.ingredientActions)).m_41619_()) {
                            leftStack = actioned;
                            didRunIngredientAction = true;
                        }
                        if (!didRunIngredientAction) {
                            leftStack = capability.insertItem(i, output.m_41777_(), false);
                        }
                        output.m_41764_(leftStack.m_41613_());
                        if (output.m_41619_()) break;
                    }
                }
                if (!output.m_41619_()) continue;
                iterator.remove();
            }
        }
        return left.isEmpty() ? null : left;
    }

    @Override
    public RecipeCapability<Ingredient> getCapability() {
        return ItemRecipeCapability.CAP;
    }

    public int getSlots() {
        return this.storage.getSlots();
    }

    @Override
    public int getSize() {
        return this.getSlots();
    }

    @Override
    public List<Object> getContents() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            stacks.add(stack);
        }
        return Arrays.asList(stacks.toArray());
    }

    @Override
    public double getTotalContentAmount() {
        long amount = 0L;
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            amount += (long)stack.m_41613_();
        }
        return amount;
    }

    public boolean isEmpty() {
        if (this.isEmpty == null) {
            this.isEmpty = true;
            for (int i = 0; i < this.storage.getSlots(); ++i) {
                if (this.storage.getStackInSlot(i).m_41619_()) continue;
                this.isEmpty = false;
                break;
            }
        }
        return this.isEmpty;
    }

    public void exportToNearby(Direction ... facings) {
        if (this.isEmpty()) {
            return;
        }
        Level level = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        for (Direction facing : facings) {
            ItemTransferHelper.exportToTarget((IItemTransfer)this, (int)Integer.MAX_VALUE, f -> true, (Level)level, (BlockPos)pos.m_121945_(facing), (Direction)facing.m_122424_());
        }
    }

    public void importFromNearby(Direction ... facings) {
        Level level = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        for (Direction facing : facings) {
            ItemTransferHelper.importToTarget((IItemTransfer)this, (int)Integer.MAX_VALUE, f -> true, (Level)level, (BlockPos)pos.m_121945_(facing), (Direction)facing.m_122424_());
        }
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.storage.getStackInSlot(slot);
    }

    public void setStackInSlot(int index, ItemStack stack) {
        this.storage.setStackInSlot(index, stack);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate, boolean notifyChange) {
        if (this.canCapInput()) {
            return this.storage.insertItem(slot, stack, simulate, notifyChange);
        }
        return stack;
    }

    public ItemStack insertItemInternal(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.storage.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate, boolean notifyChange) {
        if (this.canCapOutput()) {
            return this.storage.extractItem(slot, amount, simulate, notifyChange);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        return this.storage.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.storage.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.storage.isItemValid(slot, stack);
    }

    @NotNull
    public Object createSnapshot() {
        return this.storage.createSnapshot();
    }

    public void restoreFromSnapshot(Object snapshot) {
        this.storage.restoreFromSnapshot(snapshot);
    }

    @Override
    public IO getHandlerIO() {
        return this.handlerIO;
    }

    @Override
    public IO getCapabilityIO() {
        return this.capabilityIO;
    }

    public static class KJSCallWrapper {
        public static ItemStack applyIngredientAction(ItemStackTransfer storage, int index, List<IngredientAction> ingredientActions) {
            ItemStack stack = storage.getStackInSlot(index);
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            DummyCraftingContainer container = new DummyCraftingContainer((IItemTransfer)storage);
            for (IngredientAction action : ingredientActions) {
                if (!action.checkFilter(index, stack)) continue;
                return action.transform(stack.m_41777_(), index, (CraftingContainer)container);
            }
            return ItemStack.f_41583_;
        }
    }
}

