/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FluidRecipeHandler
implements IRecipeHandler<FluidIngredient> {
    public final IO handlerIO;
    @Persisted
    private final FluidStorage[] storages;

    public FluidRecipeHandler(IO handlerIO, int slots, long capacity) {
        this.handlerIO = handlerIO;
        this.storages = new FluidStorage[slots];
        for (int i = 0; i < this.storages.length; ++i) {
            this.storages[i] = new FluidStorage(capacity);
        }
    }

    @Override
    public List<FluidIngredient> handleRecipeInner(IO io, GTRecipe recipe, List<FluidIngredient> left, @Nullable String slotName, boolean simulate) {
        return NotifiableFluidTank.handleIngredient(io, recipe, left, simulate, this.handlerIO, this.getStorages());
    }

    @Override
    public List<Object> getContents() {
        ArrayList<FluidStack> ingredients = new ArrayList<FluidStack>();
        for (FluidStorage storage : this.getStorages()) {
            FluidStack stack = storage.getFluid();
            if (stack.isEmpty()) continue;
            ingredients.add(stack);
        }
        return Arrays.asList(ingredients.toArray());
    }

    @Override
    public double getTotalContentAmount() {
        long amount = 0L;
        for (FluidStorage storage : this.getStorages()) {
            FluidStack stack = storage.getFluid();
            if (stack.isEmpty()) continue;
            amount += stack.getAmount();
        }
        return amount;
    }

    @Override
    public int getSize() {
        return this.getStorages().length;
    }

    @Override
    public RecipeCapability<FluidIngredient> getCapability() {
        return FluidRecipeCapability.CAP;
    }

    public IO getHandlerIO() {
        return this.handlerIO;
    }

    public FluidStorage[] getStorages() {
        return this.storages;
    }
}

