/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc.forge;

import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.jetbrains.annotations.NotNull;

public class VoidFluidHandlerItemStack
extends FluidHandlerItemStack {
    public VoidFluidHandlerItemStack(@NotNull ItemStack container) {
        this(container, Integer.MAX_VALUE);
    }

    public VoidFluidHandlerItemStack(@NotNull ItemStack container, int capacity) {
        super(container, capacity);
    }

    public FluidStack getFluid() {
        return FluidStack.EMPTY;
    }

    protected void setFluid(FluidStack fluid) {
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        if (resource.isEmpty() || resource.getAmount() <= 0) {
            return 0;
        }
        return Math.min(this.capacity, resource.getAmount());
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
        return FluidStack.EMPTY;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return true;
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return false;
    }
}

