/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pattern.util;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;

public enum RelativeDirection {
    UP(f -> Direction.UP, Direction.Axis.Y),
    DOWN(f -> Direction.DOWN, Direction.Axis.Y),
    LEFT(Direction::m_122428_, Direction.Axis.X),
    RIGHT(Direction::m_122427_, Direction.Axis.X),
    FRONT(Function.identity(), Direction.Axis.Z),
    BACK(Direction::m_122424_, Direction.Axis.Z);

    final Function<Direction, Direction> actualFacing;
    public final Direction.Axis axis;

    private RelativeDirection(Function<Direction, Direction> actualFacing, Direction.Axis axis) {
        this.actualFacing = actualFacing;
        this.axis = axis;
    }

    public Direction getActualFacing(Direction facing) {
        return this.getRelativeFacing(facing, Direction.NORTH, false);
    }

    public boolean isSameAxis(RelativeDirection dir) {
        return this.axis == dir.axis;
    }

    public Vec3i applyVec3i(Direction facing) {
        return this.getActualFacing(facing).m_122436_();
    }

    public Direction getRelativeFacing(Direction frontFacing, Direction upwardsFacing, boolean isFlipped) {
        Direction.Axis frontAxis = frontFacing.m_122434_();
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case UP -> {
                if (frontAxis == Direction.Axis.Y) {
                    yield upwardsFacing;
                }
                switch (upwardsFacing) {
                    case NORTH: {
                        yield Direction.UP;
                    }
                    case SOUTH: {
                        yield Direction.DOWN;
                    }
                    case EAST: {
                        yield frontFacing.m_122428_();
                    }
                }
                yield frontFacing.m_122427_();
            }
            case DOWN -> {
                if (frontAxis == Direction.Axis.Y) {
                    yield upwardsFacing.m_122424_();
                }
                switch (upwardsFacing) {
                    case NORTH: {
                        yield Direction.DOWN;
                    }
                    case SOUTH: {
                        yield Direction.UP;
                    }
                    case EAST: {
                        yield frontFacing.m_122427_();
                    }
                }
                yield frontFacing.m_122428_();
            }
            case LEFT -> {
                Direction facing;
                if (frontAxis == Direction.Axis.Y) {
                    facing = upwardsFacing.m_122427_();
                } else {
                    switch (upwardsFacing) {
                        case NORTH: {
                            Direction v1 = frontFacing.m_122428_();
                            break;
                        }
                        case SOUTH: {
                            Direction v1 = frontFacing.m_122427_();
                            break;
                        }
                        case EAST: {
                            Direction v1 = Direction.DOWN;
                            break;
                        }
                        default: {
                            Direction v1 = facing = Direction.UP;
                        }
                    }
                }
                if (isFlipped) {
                    yield facing.m_122424_();
                }
                yield facing;
            }
            case RIGHT -> {
                Direction facing;
                if (frontAxis == Direction.Axis.Y) {
                    facing = upwardsFacing.m_122428_();
                } else {
                    switch (upwardsFacing) {
                        case NORTH: {
                            Direction v2 = frontFacing.m_122427_();
                            break;
                        }
                        case SOUTH: {
                            Direction v2 = frontFacing.m_122428_();
                            break;
                        }
                        case EAST: {
                            Direction v2 = Direction.UP;
                            break;
                        }
                        default: {
                            Direction v2 = facing = Direction.DOWN;
                        }
                    }
                }
                if (isFlipped) {
                    yield facing.m_122424_();
                }
                yield facing;
            }
            case FRONT -> frontFacing;
            case BACK -> frontFacing.m_122424_();
        };
    }

    public Function<BlockPos, Integer> getSorter(Direction frontFacing, Direction upwardsFacing, boolean isFlipped) {
        Direction sorterDirection = this.getRelativeFacing(frontFacing, upwardsFacing, isFlipped);
        return switch (sorterDirection) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> Vec3i::m_123342_;
            case Direction.DOWN -> pos -> -pos.m_123342_();
            case Direction.EAST -> Vec3i::m_123341_;
            case Direction.WEST -> pos -> -pos.m_123341_();
            case Direction.NORTH -> pos -> -pos.m_123343_();
            case Direction.SOUTH -> Vec3i::m_123343_;
        };
    }

    public static Direction simulateAxisRotation(Direction newFrontFacing, Direction oldFrontFacing, Direction upwardsFacing) {
        if (newFrontFacing == oldFrontFacing) {
            return upwardsFacing;
        }
        Direction.Axis newAxis = newFrontFacing.m_122434_();
        Direction.Axis oldAxis = oldFrontFacing.m_122434_();
        if (newAxis != Direction.Axis.Y && oldAxis != Direction.Axis.Y) {
            return upwardsFacing;
        }
        if (newAxis == Direction.Axis.Y && oldAxis != Direction.Axis.Y) {
            Direction newUpwardsFacing = switch (upwardsFacing) {
                case Direction.NORTH -> oldFrontFacing.m_122424_();
                case Direction.SOUTH -> oldFrontFacing;
                case Direction.EAST -> oldFrontFacing.m_122428_();
                default -> oldFrontFacing.m_122427_();
            };
            return newFrontFacing == Direction.DOWN && upwardsFacing.m_122434_() == Direction.Axis.Z ? newUpwardsFacing.m_122424_() : newUpwardsFacing;
        }
        if (newAxis != Direction.Axis.Y) {
            Direction newUpwardsFacing = upwardsFacing == newFrontFacing.m_122424_() ? Direction.NORTH : (upwardsFacing == newFrontFacing ? Direction.SOUTH : (upwardsFacing == newFrontFacing.m_122427_() ? Direction.WEST : Direction.EAST));
            return oldFrontFacing == Direction.DOWN && newUpwardsFacing.m_122434_() == Direction.Axis.Z ? newUpwardsFacing.m_122424_() : newUpwardsFacing;
        }
        return upwardsFacing.m_122424_();
    }

    public static BlockPos offsetPos(BlockPos pos, Direction frontFacing, Direction upwardsFacing, boolean isFlipped, int upOffset, int leftOffset, int forwardOffset) {
        if (upOffset == 0 && leftOffset == 0 && forwardOffset == 0) {
            return pos;
        }
        int oX = 0;
        int oY = 0;
        int oZ = 0;
        Direction relUp = UP.getRelativeFacing(frontFacing, upwardsFacing, isFlipped);
        oX += relUp.m_122429_() * upOffset;
        oY += relUp.m_122430_() * upOffset;
        oZ += relUp.m_122431_() * upOffset;
        Direction relLeft = LEFT.getRelativeFacing(frontFacing, upwardsFacing, isFlipped);
        oX += relLeft.m_122429_() * leftOffset;
        oY += relLeft.m_122430_() * leftOffset;
        oZ += relLeft.m_122431_() * leftOffset;
        Direction relForward = FRONT.getRelativeFacing(frontFacing, upwardsFacing, isFlipped);
        return pos.m_7918_(oX += relForward.m_122429_() * forwardOffset, oY += relForward.m_122430_() * forwardOffset, oZ += relForward.m_122431_() * forwardOffset);
    }
}

