/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.ResearchData;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.recipe.ResearchCondition;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.NotNull;

public class GTRecipeSerializer
implements RecipeSerializer<GTRecipe> {
    public static final GTRecipeSerializer SERIALIZER = new GTRecipeSerializer();

    public Map<RecipeCapability<?>, List<Content>> capabilitiesFromJson(JsonObject json) {
        IdentityHashMap capabilities = new IdentityHashMap();
        for (String key : json.keySet()) {
            JsonArray contentsJson = json.getAsJsonArray(key);
            RecipeCapability capability = (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(key);
            if (capability == null) continue;
            ArrayList<Content> contents = new ArrayList<Content>();
            for (JsonElement contentJson : contentsJson) {
                contents.add(capability.serializer.fromJsonContent(contentJson));
            }
            capabilities.put(capability, contents);
        }
        return capabilities;
    }

    public Map<RecipeCapability<?>, ChanceLogic> chanceLogicsFromJson(JsonObject json) {
        IdentityHashMap chanceLogics = new IdentityHashMap();
        for (String key : json.keySet()) {
            String value = json.get(key).getAsString();
            chanceLogics.put((RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(key), (ChanceLogic)GTRegistries.CHANCE_LOGICS.get(value));
        }
        return chanceLogics;
    }

    @NotNull
    public GTRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
        String recipeType = GsonHelper.m_13906_((JsonObject)json, (String)"type");
        int duration = json.has("duration") ? GsonHelper.m_13927_((JsonObject)json, (String)"duration") : 100;
        CompoundTag data = new CompoundTag();
        if (json.has("data")) {
            data = CraftingHelper.getNBT((JsonElement)json.get("data"));
        }
        Map<RecipeCapability<?>, List<Content>> inputs = this.capabilitiesFromJson(json.has("inputs") ? json.getAsJsonObject("inputs") : new JsonObject());
        Map<RecipeCapability<?>, List<Content>> tickInputs = this.capabilitiesFromJson(json.has("tickInputs") ? json.getAsJsonObject("tickInputs") : new JsonObject());
        Map<RecipeCapability<?>, List<Content>> outputs = this.capabilitiesFromJson(json.has("outputs") ? json.getAsJsonObject("outputs") : new JsonObject());
        Map<RecipeCapability<?>, List<Content>> tickOutputs = this.capabilitiesFromJson(json.has("tickOutputs") ? json.getAsJsonObject("tickOutputs") : new JsonObject());
        Map<RecipeCapability<?>, ChanceLogic> inputChanceLogics = this.chanceLogicsFromJson(json.has("inputChanceLogics") ? json.getAsJsonObject("inputChanceLogics") : new JsonObject());
        Map<RecipeCapability<?>, ChanceLogic> tickInputChanceLogics = this.chanceLogicsFromJson(json.has("tickInputChanceLogics") ? json.getAsJsonObject("tickInputChanceLogics") : new JsonObject());
        Map<RecipeCapability<?>, ChanceLogic> outputChanceLogics = this.chanceLogicsFromJson(json.has("outputChanceLogics") ? json.getAsJsonObject("outputChanceLogics") : new JsonObject());
        Map<RecipeCapability<?>, ChanceLogic> tickOutputChanceLogics = this.chanceLogicsFromJson(json.has("tickOutputChanceLogics") ? json.getAsJsonObject("tickOutputChanceLogics") : new JsonObject());
        ArrayList<RecipeCondition> conditions = new ArrayList<RecipeCondition>();
        JsonArray conditionsJson = json.has("recipeConditions") ? json.getAsJsonArray("recipeConditions") : new JsonArray();
        for (JsonElement jsonElement : conditionsJson) {
            RecipeCondition condition;
            JsonObject jsonObject;
            String conditionKey;
            Class clazz;
            if (!(jsonElement instanceof JsonObject) || (clazz = (Class)GTRegistries.RECIPE_CONDITIONS.get(conditionKey = GsonHelper.m_13851_((JsonObject)(jsonObject = (JsonObject)jsonElement), (String)"type", (String)""))) == null || (condition = RecipeCondition.create(clazz)) == null) continue;
            conditions.add(condition.deserialize(GsonHelper.m_13841_((JsonObject)jsonObject, (String)"data", (JsonObject)new JsonObject())));
        }
        List<Object> ingredientActions = new ArrayList();
        if (GTCEu.isKubeJSLoaded()) {
            ingredientActions = KJSCallWrapper.getIngredientActions(json);
        }
        boolean isFuel = GsonHelper.m_13855_((JsonObject)json, (String)"isFuel", (boolean)false);
        return new GTRecipe((GTRecipeType)BuiltInRegistries.f_256990_.m_7745_(new ResourceLocation(recipeType)), id, inputs, outputs, tickInputs, tickOutputs, inputChanceLogics, outputChanceLogics, tickInputChanceLogics, tickOutputChanceLogics, conditions, ingredientActions, data, duration, isFuel);
    }

    public static Tuple<RecipeCapability<?>, List<Content>> entryReader(FriendlyByteBuf buf) {
        RecipeCapability capability = (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(buf.m_130277_());
        List contents = buf.m_236845_(capability.serializer::fromNetworkContent);
        return new Tuple((Object)capability, (Object)contents);
    }

    public static void entryWriter(FriendlyByteBuf buf, Map.Entry<RecipeCapability<?>, ? extends List<Content>> entry) {
        RecipeCapability<?> capability = entry.getKey();
        List<Content> contents = entry.getValue();
        buf.m_130070_((String)GTRegistries.RECIPE_CAPABILITIES.getKey(capability));
        buf.m_236828_(contents, capability.serializer::toNetworkContent);
    }

    public static RecipeCondition conditionReader(FriendlyByteBuf buf) {
        RecipeCondition condition = RecipeCondition.create((Class)GTRegistries.RECIPE_CONDITIONS.get(buf.m_130277_()));
        return condition.fromNetwork(buf);
    }

    public static void conditionWriter(FriendlyByteBuf buf, RecipeCondition condition) {
        buf.m_130070_((String)GTRegistries.RECIPE_CONDITIONS.getKey(condition.getClass()));
        condition.toNetwork(buf);
    }

    public static Map<RecipeCapability<?>, List<Content>> tuplesToMap(List<Tuple<RecipeCapability<?>, List<Content>>> entries) {
        HashMap map = new HashMap();
        entries.forEach(entry -> map.put((RecipeCapability)entry.m_14418_(), (List)entry.m_14419_()));
        return map;
    }

    @NotNull
    public GTRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
        CompoundTag data;
        ResourceLocation recipeType = buf.m_130281_();
        int duration = buf.m_130242_();
        Map<RecipeCapability<?>, List<Content>> inputs = GTRecipeSerializer.tuplesToMap((List)buf.m_236838_(c -> new ArrayList(), GTRecipeSerializer::entryReader));
        Map<RecipeCapability<?>, List<Content>> tickInputs = GTRecipeSerializer.tuplesToMap((List)buf.m_236838_(c -> new ArrayList(), GTRecipeSerializer::entryReader));
        Map<RecipeCapability<?>, List<Content>> outputs = GTRecipeSerializer.tuplesToMap((List)buf.m_236838_(c -> new ArrayList(), GTRecipeSerializer::entryReader));
        Map<RecipeCapability<?>, List<Content>> tickOutputs = GTRecipeSerializer.tuplesToMap((List)buf.m_236838_(c -> new ArrayList(), GTRecipeSerializer::entryReader));
        Map inputChanceLogics = buf.m_236847_(buf1 -> (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(buf1.m_130277_()), buf1 -> (ChanceLogic)GTRegistries.CHANCE_LOGICS.get(buf1.m_130277_()));
        Map outputChanceLogics = buf.m_236847_(buf1 -> (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(buf1.m_130277_()), buf1 -> (ChanceLogic)GTRegistries.CHANCE_LOGICS.get(buf1.m_130277_()));
        Map tickInputChanceLogics = buf.m_236847_(buf1 -> (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(buf1.m_130277_()), buf1 -> (ChanceLogic)GTRegistries.CHANCE_LOGICS.get(buf1.m_130277_()));
        Map tickOutputChanceLogics = buf.m_236847_(buf1 -> (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(buf1.m_130277_()), buf1 -> (ChanceLogic)GTRegistries.CHANCE_LOGICS.get(buf1.m_130277_()));
        List conditions = (List)buf.m_236838_(c -> new ArrayList(), GTRecipeSerializer::conditionReader);
        List<Object> ingredientActions = new ArrayList();
        if (GTCEu.isKubeJSLoaded()) {
            ingredientActions = KJSCallWrapper.getIngredientActions(buf);
        }
        if ((data = buf.m_130260_()) == null) {
            data = new CompoundTag();
        }
        boolean isFuel = buf.readBoolean();
        GTRecipeType type = (GTRecipeType)BuiltInRegistries.f_256990_.m_7745_(recipeType);
        GTRecipe recipe = new GTRecipe(type, id, inputs, outputs, tickInputs, tickOutputs, inputChanceLogics, outputChanceLogics, tickInputChanceLogics, tickOutputChanceLogics, conditions, ingredientActions, data, duration, isFuel);
        ResearchCondition researchCondition = conditions.stream().filter(ResearchCondition.class::isInstance).findAny().map(ResearchCondition.class::cast).orElse(null);
        if (researchCondition != null) {
            for (ResearchData.ResearchEntry entry : researchCondition.data) {
                type.addDataStickEntry(entry.getResearchId(), recipe);
            }
        }
        return recipe;
    }

    public void toNetwork(FriendlyByteBuf buf, GTRecipe recipe) {
        buf.m_130085_(recipe.recipeType.registryName);
        buf.m_130130_(recipe.duration);
        buf.m_236828_(recipe.inputs.entrySet(), GTRecipeSerializer::entryWriter);
        buf.m_236828_(recipe.tickInputs.entrySet(), GTRecipeSerializer::entryWriter);
        buf.m_236828_(recipe.outputs.entrySet(), GTRecipeSerializer::entryWriter);
        buf.m_236828_(recipe.tickOutputs.entrySet(), GTRecipeSerializer::entryWriter);
        buf.m_236831_(recipe.inputChanceLogics, (buf1, cap) -> buf1.m_130070_((String)GTRegistries.RECIPE_CAPABILITIES.getKey((RecipeCapability<?>)cap)), (buf1, logic) -> buf1.m_130070_((String)GTRegistries.CHANCE_LOGICS.getKey((ChanceLogic)logic)));
        buf.m_236831_(recipe.outputChanceLogics, (buf1, cap) -> buf1.m_130070_((String)GTRegistries.RECIPE_CAPABILITIES.getKey((RecipeCapability<?>)cap)), (buf1, logic) -> buf1.m_130070_((String)GTRegistries.CHANCE_LOGICS.getKey((ChanceLogic)logic)));
        buf.m_236831_(recipe.tickInputChanceLogics, (buf1, cap) -> buf1.m_130070_((String)GTRegistries.RECIPE_CAPABILITIES.getKey((RecipeCapability<?>)cap)), (buf1, logic) -> buf1.m_130070_((String)GTRegistries.CHANCE_LOGICS.getKey((ChanceLogic)logic)));
        buf.m_236831_(recipe.tickOutputChanceLogics, (buf1, cap) -> buf1.m_130070_((String)GTRegistries.RECIPE_CAPABILITIES.getKey((RecipeCapability<?>)cap)), (buf1, logic) -> buf1.m_130070_((String)GTRegistries.CHANCE_LOGICS.getKey((ChanceLogic)logic)));
        buf.m_236828_(recipe.conditions, GTRecipeSerializer::conditionWriter);
        if (GTCEu.isKubeJSLoaded()) {
            KJSCallWrapper.writeIngredientActions(recipe.ingredientActions, buf);
        }
        buf.m_130079_(recipe.data);
        buf.writeBoolean(recipe.isFuel);
    }

    public static class KJSCallWrapper {
        public static List<?> getIngredientActions(JsonObject json) {
            return IngredientAction.parseList((JsonElement)json.get("kubejs:actions"));
        }

        public static List<?> getIngredientActions(FriendlyByteBuf buf) {
            return IngredientAction.readList((FriendlyByteBuf)buf);
        }

        public static void writeIngredientActions(List<?> ingredientActions, FriendlyByteBuf buf) {
            IngredientAction.writeList((FriendlyByteBuf)buf, ingredientActions);
        }
    }
}

