/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import it.unimi.dsi.fastutil.longs.LongIntMutablePair;
import it.unimi.dsi.fastutil.longs.LongIntPair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.jetbrains.annotations.NotNull;

public class OverclockingLogic {
    public static final double STANDARD_OVERCLOCK_VOLTAGE_MULTIPLIER = 4.0;
    public static final double STANDARD_OVERCLOCK_DURATION_DIVISOR = ConfigHolder.INSTANCE.machines.overclockDivisor;
    public static final double PERFECT_OVERCLOCK_DURATION_DIVISOR = 4.0;
    public static final OverclockingLogic PERFECT_OVERCLOCK = new OverclockingLogic(4.0, 4.0);
    public static final OverclockingLogic NON_PERFECT_OVERCLOCK = new OverclockingLogic(STANDARD_OVERCLOCK_DURATION_DIVISOR, 4.0);
    protected Logic logic;

    public OverclockingLogic(Logic logic) {
        this.logic = logic;
    }

    public OverclockingLogic(double durationDivisor, double voltageMultiplier) {
        this.logic = (recipe, recipeEUt, maxVoltage, duration, amountOC) -> OverclockingLogic.standardOverclockingLogic(Math.abs(recipeEUt), maxVoltage, duration, amountOC, durationDivisor, voltageMultiplier);
    }

    @NotNull
    public static LongIntPair standardOverclockingLogic(long recipeEUt, long maxVoltage, int recipeDuration, int numberOfOCs, double durationDivisor, double voltageMultiplier) {
        double potentialDuration;
        double potentialVoltage;
        double resultDuration = recipeDuration;
        double resultVoltage = recipeEUt;
        while (numberOfOCs > 0 && !((potentialVoltage = resultVoltage * voltageMultiplier) > (double)maxVoltage) && !((potentialDuration = resultDuration / durationDivisor) < 1.0)) {
            resultDuration = potentialDuration;
            resultVoltage = potentialVoltage;
            --numberOfOCs;
        }
        return LongIntMutablePair.of((long)((long)resultVoltage), (int)((int)resultDuration));
    }

    @NotNull
    public static ImmutableTriple<Long, Integer, Integer> standardOverclockingLogicWithSubTickParallelCount(long recipeEUt, long maxVoltage, int recipeDuration, int numberOfOCs, double durationDivisor, double voltageMultiplier) {
        double potentialVoltage;
        double resultDuration = recipeDuration;
        double resultVoltage = recipeEUt;
        double resultParallel = 1.0;
        while (numberOfOCs > 0 && !((potentialVoltage = resultVoltage * voltageMultiplier) > (double)maxVoltage)) {
            double potentialDuration = resultDuration / durationDivisor;
            if (potentialDuration < 1.0) {
                resultParallel *= durationDivisor;
                if (potentialDuration > 1.0 / durationDivisor) {
                    potentialDuration *= durationDivisor;
                }
            }
            resultDuration = Math.max(1.0, potentialDuration);
            resultVoltage = potentialVoltage;
            --numberOfOCs;
        }
        return ImmutableTriple.of((Object)((long)resultVoltage), (Object)((int)resultDuration), (Object)((int)resultParallel));
    }

    @NotNull
    public static LongIntPair heatingCoilOverclockingLogic(long recipeEUt, long maximumVoltage, int recipeDuration, int maxOverclocks, int currentTemp, int recipeRequiredTemp) {
        int amountEUDiscount = Math.max(0, (currentTemp - recipeRequiredTemp) / 900);
        int amountPerfectOC = amountEUDiscount / 2;
        recipeEUt = (long)((double)recipeEUt * Math.min(1.0, Math.pow(0.95, amountEUDiscount)));
        if (amountPerfectOC > 0) {
            LongIntPair overclock = OverclockingLogic.standardOverclockingLogic(recipeEUt, maximumVoltage, recipeDuration, amountPerfectOC, 4.0, 4.0);
            return OverclockingLogic.standardOverclockingLogic(overclock.leftLong(), maximumVoltage, overclock.rightInt(), maxOverclocks - amountPerfectOC, STANDARD_OVERCLOCK_DURATION_DIVISOR, 4.0);
        }
        return OverclockingLogic.standardOverclockingLogic(recipeEUt, maximumVoltage, recipeDuration, maxOverclocks, STANDARD_OVERCLOCK_DURATION_DIVISOR, 4.0);
    }

    protected int getOverclockForTier(long voltage) {
        return GTUtil.getTierByVoltage(voltage);
    }

    public Logic getLogic() {
        return this.logic;
    }

    @FunctionalInterface
    public static interface Logic {
        public LongIntPair runOverclockingLogic(@NotNull GTRecipe var1, long var2, long var4, int var6, int var7);
    }
}

