/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RecipeCondition {
    protected boolean isReverse;

    @Nullable
    public static RecipeCondition create(Class<? extends RecipeCondition> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception ignored) {
            GTCEu.LOGGER.error("condition {} has no NonArgsConstructor", clazz);
            return null;
        }
    }

    public abstract String getType();

    public String getTranslationKey() {
        return "gtceu.recipe.condition." + this.getType();
    }

    public IGuiTexture getInValidTexture() {
        return new ResourceTexture("gtceu:textures/gui/condition/" + this.getType() + ".png").getSubTexture(0.0f, 0.0f, 1.0f, 0.5f);
    }

    public IGuiTexture getValidTexture() {
        return new ResourceTexture("gtceu:textures/gui/condition/" + this.getType() + ".png").getSubTexture(0.0f, 0.5f, 1.0f, 0.5f);
    }

    public boolean isReverse() {
        return this.isReverse;
    }

    public boolean isOr() {
        return false;
    }

    public RecipeCondition setReverse(boolean reverse) {
        this.isReverse = reverse;
        return this;
    }

    public abstract Component getTooltips();

    public abstract boolean test(@NotNull GTRecipe var1, @NotNull RecipeLogic var2);

    public abstract RecipeCondition createTemplate();

    @NotNull
    public JsonObject serialize() {
        JsonObject jsonObject = new JsonObject();
        if (this.isReverse) {
            jsonObject.addProperty("reverse", Boolean.valueOf(true));
        }
        return jsonObject;
    }

    public RecipeCondition deserialize(@NotNull JsonObject config) {
        this.isReverse = GsonHelper.m_13855_((JsonObject)config, (String)"reverse", (boolean)false);
        return this;
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isReverse);
    }

    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        this.isReverse = buf.readBoolean();
        return this;
    }
}

