/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import it.unimi.dsi.fastutil.longs.LongIntPair;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class RecipeHelper {
    public static long getInputEUt(GTRecipe recipe) {
        return recipe.getTickInputContents(EURecipeCapability.CAP).stream().map(Content::getContent).mapToLong(EURecipeCapability.CAP::of).sum();
    }

    public static long getOutputEUt(GTRecipe recipe) {
        return recipe.getTickOutputContents(EURecipeCapability.CAP).stream().map(Content::getContent).mapToLong(EURecipeCapability.CAP::of).sum();
    }

    public static void setInputEUt(GTRecipe recipe, long eut) {
        recipe.getTickInputContents(EURecipeCapability.CAP).forEach(c -> {
            c.content = eut;
        });
    }

    public static void setOutputEUt(GTRecipe recipe, long eut) {
        recipe.getTickOutputContents(EURecipeCapability.CAP).forEach(c -> {
            c.content = eut;
        });
    }

    public static int getRecipeEUtTier(GTRecipe recipe) {
        long EUt = RecipeHelper.getInputEUt(recipe);
        if (EUt == 0L) {
            EUt = RecipeHelper.getOutputEUt(recipe);
        }
        return GTUtil.getTierByVoltage(EUt);
    }

    public static GTRecipe applyOverclock(OverclockingLogic logic, @NotNull GTRecipe recipe, long maxOverclockVoltage) {
        LongIntPair overclockResult;
        long EUt = RecipeHelper.getInputEUt(recipe);
        if (EUt > 0L && ((overclockResult = RecipeHelper.performOverclocking(logic, recipe, EUt, maxOverclockVoltage)).leftLong() != EUt || recipe.duration != overclockResult.rightInt())) {
            recipe = recipe.copy();
            recipe.duration = overclockResult.rightInt();
            for (Content content : recipe.getTickInputContents(EURecipeCapability.CAP)) {
                content.content = overclockResult.leftLong();
            }
        }
        if ((EUt = RecipeHelper.getOutputEUt(recipe)) > 0L && ((overclockResult = RecipeHelper.performOverclocking(logic, recipe, EUt, maxOverclockVoltage)).leftLong() != EUt || recipe.duration != overclockResult.rightInt())) {
            recipe = recipe.copy();
            recipe.duration = overclockResult.rightInt();
            for (Content content : recipe.getTickOutputContents(EURecipeCapability.CAP)) {
                content.content = overclockResult.leftLong();
            }
        }
        return recipe;
    }

    public static LongIntPair performOverclocking(OverclockingLogic logic, @NotNull GTRecipe recipe, long EUt, long maxOverclockVoltage) {
        byte recipeTier;
        int maximumTier = maxOverclockVoltage < Integer.MAX_VALUE ? logic.getOverclockForTier(maxOverclockVoltage) : GTUtil.getFakeVoltageTier(maxOverclockVoltage);
        int numberOfOCs = maximumTier - (recipeTier = GTUtil.getTierByVoltage(EUt));
        if (numberOfOCs <= 0) {
            return LongIntPair.of((long)EUt, (int)recipe.duration);
        }
        if (recipeTier == 0) {
            --numberOfOCs;
        }
        return logic.getLogic().runOverclockingLogic(recipe, EUt, maxOverclockVoltage, recipe.duration, numberOfOCs);
    }

    public static <T> List<T> getInputContents(GTRecipeBuilder builder, RecipeCapability<T> capability) {
        return builder.input.getOrDefault(capability, Collections.emptyList()).stream().map(content -> capability.of(content.getContent())).collect(Collectors.toList());
    }

    public static <T> List<T> getInputContents(GTRecipe recipe, RecipeCapability<T> capability) {
        return recipe.getInputContents(capability).stream().map(content -> capability.of(content.getContent())).collect(Collectors.toList());
    }

    public static <T> List<T> getOutputContents(GTRecipeBuilder builder, RecipeCapability<T> capability) {
        return builder.output.getOrDefault(capability, Collections.emptyList()).stream().map(content -> capability.of(content.getContent())).collect(Collectors.toList());
    }

    public static <T> List<T> getOutputContents(GTRecipe recipe, RecipeCapability<T> capability) {
        return recipe.getOutputContents(capability).stream().map(content -> capability.of(content.getContent())).collect(Collectors.toList());
    }

    public static List<ItemStack> getInputItems(GTRecipe recipe) {
        return recipe.getInputContents(ItemRecipeCapability.CAP).stream().map(content -> (Ingredient)ItemRecipeCapability.CAP.of(content.getContent())).map(ingredient -> ingredient.m_43908_()[0]).collect(Collectors.toList());
    }

    public static List<FluidStack> getInputFluids(GTRecipe recipe) {
        return recipe.getInputContents(FluidRecipeCapability.CAP).stream().map(content -> (FluidIngredient)FluidRecipeCapability.CAP.of(content.getContent())).map(ingredient -> ingredient.getStacks()[0]).collect(Collectors.toList());
    }

    public static List<ItemStack> getOutputItems(GTRecipe recipe) {
        return recipe.getOutputContents(ItemRecipeCapability.CAP).stream().map(content -> (Ingredient)ItemRecipeCapability.CAP.of(content.getContent())).map(ingredient -> ingredient.m_43908_()[0]).collect(Collectors.toList());
    }

    public static List<ItemStack> getOutputItems(GTRecipeBuilder builder) {
        return builder.output.getOrDefault(ItemRecipeCapability.CAP, Collections.emptyList()).stream().map(content -> (Ingredient)ItemRecipeCapability.CAP.of(content.getContent())).map(ingredient -> ingredient.m_43908_()[0]).collect(Collectors.toList());
    }

    public static List<FluidStack> getOutputFluids(GTRecipe recipe) {
        return recipe.getOutputContents(FluidRecipeCapability.CAP).stream().map(content -> (FluidIngredient)FluidRecipeCapability.CAP.of(content.getContent())).map(ingredient -> ingredient.getStacks()[0]).collect(Collectors.toList());
    }

    public static List<FluidStack> getOutputFluids(GTRecipeBuilder builder) {
        return builder.output.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList()).stream().map(content -> (FluidIngredient)FluidRecipeCapability.CAP.of(content.getContent())).map(ingredient -> ingredient.getStacks()[0]).collect(Collectors.toList());
    }
}

