/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.item.IComponentItem;
import com.gregtechceu.gtceu.api.item.component.IDataItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.GTStringUtils;
import com.gregtechceu.gtceu.utils.ResearchManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class ResearchRecipeBuilder<T extends ResearchRecipeBuilder<T>> {
    protected ItemStack researchStack;
    protected ItemStack dataStack;
    protected String researchId;
    protected int eut;

    public T researchStack(@NotNull ItemStack researchStack) {
        if (!researchStack.m_41619_()) {
            this.researchStack = researchStack;
        }
        return (T)this;
    }

    public T dataStack(@NotNull ItemStack dataStack) {
        if (!dataStack.m_41619_()) {
            this.dataStack = dataStack;
        }
        return (T)this;
    }

    public T researchId(String researchId) {
        this.researchId = researchId;
        return (T)this;
    }

    public T EUt(int eut) {
        this.eut = eut;
        return (T)this;
    }

    protected void validateResearchItem() {
        if (this.researchStack == null) {
            throw new IllegalArgumentException("Research stack cannot be null or empty!");
        }
        if (this.researchId == null) {
            this.researchId = GTStringUtils.itemStackToString(this.researchStack);
        }
        if (this.dataStack == null) {
            this.dataStack = this.getDefaultDataItem();
        }
        boolean foundBehavior = false;
        Item item = this.dataStack.m_41720_();
        if (item instanceof IComponentItem) {
            IComponentItem metaItem = (IComponentItem)item;
            for (IItemComponent behaviour : metaItem.getComponents()) {
                if (!(behaviour instanceof IDataItem)) continue;
                foundBehavior = true;
                this.dataStack = this.dataStack.m_41777_();
                this.dataStack.m_41764_(1);
                break;
            }
        }
        if (!foundBehavior) {
            throw new IllegalArgumentException("Data ItemStack must have the IDataItem behavior");
        }
    }

    public abstract ItemStack getDefaultDataItem();

    public abstract GTRecipeBuilder.ResearchRecipeEntry build();

    public static class StationRecipeBuilder
    extends ResearchRecipeBuilder<StationRecipeBuilder> {
        public static final int DEFAULT_STATION_EUT = GTValues.VA[6];
        public static final int DEFAULT_STATION_TOTAL_CWUT = 4000;
        private int cwut;
        private int totalCWU;

        public StationRecipeBuilder CWUt(int cwut) {
            this.cwut = cwut;
            this.totalCWU = cwut * 4000;
            return this;
        }

        public StationRecipeBuilder CWUt(int cwut, int totalCWU) {
            this.cwut = cwut;
            this.totalCWU = totalCWU;
            return this;
        }

        @Override
        public ItemStack getDefaultDataItem() {
            return ResearchManager.getDefaultResearchStationItem(this.cwut);
        }

        @Override
        public GTRecipeBuilder.ResearchRecipeEntry build() {
            this.validateResearchItem();
            if (this.cwut <= 0 || this.totalCWU <= 0) {
                throw new IllegalArgumentException("CWU/t and total CWU must both be set, and non-zero!");
            }
            if (this.cwut > this.totalCWU) {
                throw new IllegalArgumentException("Total CWU cannot be greater than CWU/t!");
            }
            int duration = this.totalCWU;
            if (this.eut <= 0) {
                this.eut = DEFAULT_STATION_EUT;
            }
            return new GTRecipeBuilder.ResearchRecipeEntry(this.researchId, this.researchStack, this.dataStack, duration, this.eut, this.cwut);
        }
    }

    public static class ScannerRecipeBuilder
    extends ResearchRecipeBuilder<ScannerRecipeBuilder> {
        public static final int DEFAULT_SCANNER_DURATION = 1200;
        public static final int DEFAULT_SCANNER_EUT = GTValues.VA[3];
        private int duration;

        public ScannerRecipeBuilder duration(int duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public ItemStack getDefaultDataItem() {
            return ResearchManager.getDefaultScannerItem();
        }

        @Override
        public GTRecipeBuilder.ResearchRecipeEntry build() {
            this.validateResearchItem();
            if (this.duration <= 0) {
                this.duration = 1200;
            }
            if (this.eut <= 0) {
                this.eut = DEFAULT_SCANNER_EUT;
            }
            return new GTRecipeBuilder.ResearchRecipeEntry(this.researchId, this.researchStack, this.dataStack, this.duration, this.eut, 0);
        }
    }
}

