/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.content;

import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class Content {
    public Object content;
    public int chance;
    public int maxChance;
    public int tierChanceBoost;
    @Nullable
    public String slotName;
    @Nullable
    public String uiName;

    public Content(Object content, int chance, int maxChance, int tierChanceBoost, @Nullable String slotName, @Nullable String uiName) {
        this.content = content;
        this.chance = chance;
        this.maxChance = maxChance;
        this.tierChanceBoost = this.fixBoost(tierChanceBoost);
        this.slotName = slotName;
        this.uiName = uiName;
    }

    public Content copy(RecipeCapability<?> capability, @Nullable ContentModifier modifier) {
        if (modifier == null || this.chance == 0) {
            return new Content(capability.copyContent(this.content), this.chance, this.maxChance, this.tierChanceBoost, this.slotName, this.uiName);
        }
        return new Content(capability.copyContent(this.content, modifier), this.chance, this.maxChance, this.tierChanceBoost, this.slotName, this.uiName);
    }

    private int fixBoost(int chanceBoost) {
        float error = (float)ChanceLogic.getMaxChancedValue() / (float)this.maxChance;
        return Math.round((float)chanceBoost / error);
    }

    public IGuiTexture createOverlay(final boolean perTick) {
        return new IGuiTexture(){

            @OnlyIn(value=Dist.CLIENT)
            public void draw(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
                Content.this.drawChance(graphics, x, y, width, height);
                Content.this.drawRangeAmount(graphics, x, y, width, height);
                Content.this.drawFluidAmount(graphics, x, y, width, height);
                if (perTick) {
                    Content.this.drawTick(graphics, x, y, width, height);
                }
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawRangeAmount(GuiGraphics graphics, float x, float y, int width, int height) {
        SizedIngredient sized;
        Object object = this.content;
        if (object instanceof SizedIngredient && (object = (sized = (SizedIngredient)((Object)object)).getInner()) instanceof IntProviderIngredient) {
            IntProviderIngredient ingredient = (IntProviderIngredient)((Object)object);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
            graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
            int min = ingredient.getCountProvider().m_142739_();
            int max = ingredient.getCountProvider().m_142737_();
            String s = String.format("%s-%s", min, max);
            int color = 0xFFFFFF;
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            if (s.length() > 5) {
                s = "X-Y";
                color = 0xEE0000;
            }
            graphics.m_280056_(fontRenderer, s, (int)((x + (float)width / 3.0f) * 2.0f - (float)fontRenderer.m_92895_(s) + 21.0f), (int)((y + (float)height / 3.0f + 6.0f) * 2.0f), color, true);
            graphics.m_280168_().m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawFluidAmount(GuiGraphics graphics, float x, float y, int width, int height) {
        Object object = this.content;
        if (object instanceof FluidIngredient) {
            FluidIngredient ingredient = (FluidIngredient)object;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
            graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
            long amount = ingredient.getAmount();
            String s = amount >= 1000L ? (amount /= 1000L) + "B" : amount + "mB";
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            graphics.m_280056_(fontRenderer, s, (int)((x + (float)width / 3.0f) * 2.0f - (float)fontRenderer.m_92895_(s) + 21.0f), (int)((y + (float)height / 3.0f + 6.0f) * 2.0f), 0xFFFFFF, true);
            graphics.m_280168_().m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawChance(GuiGraphics graphics, float x, float y, int width, int height) {
        if (this.chance == ChanceLogic.getMaxChancedValue()) {
            return;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
        float chance = 100.0f * (float)this.chance / (float)this.maxChance;
        String percent = FormattingUtil.formatPercent(chance);
        String s = chance == 0.0f ? LocalizationUtils.format((String)"gtceu.gui.content.chance_0_short", (Object[])new Object[0]) : percent + "%";
        int color = chance == 0.0f ? 0xFF0000 : 0xFFFF00;
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        graphics.m_280056_(fontRenderer, s, (int)((x + (float)width / 3.0f) * 2.0f - (float)fontRenderer.m_92895_(s) + 23.0f), (int)((y + (float)height / 3.0f + 6.0f) * 2.0f - (float)height), color, true);
        graphics.m_280168_().m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawTick(GuiGraphics graphics, float x, float y, int width, int height) {
        graphics.m_280168_().m_85836_();
        RenderSystem.disableDepthTest();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
        String s = LocalizationUtils.format((String)"gtceu.gui.content.tips.per_tick_short", (Object[])new Object[0]);
        int color = 0xFFFF00;
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        graphics.m_280488_(fontRenderer, s, (int)((x + (float)width / 3.0f) * 2.0f - (float)fontRenderer.m_92895_(s) + 23.0f), (int)((y + (float)height / 3.0f + 6.0f) * 2.0f - (float)height + (float)(this.chance == ChanceLogic.getMaxChancedValue() ? 0 : 10)), color);
        graphics.m_280168_().m_85849_();
    }

    public String toString() {
        return "Content{content=" + this.content + ", chance=" + this.chance + ", maxChance=" + this.maxChance + ", tierChanceBoost=" + this.tierChanceBoost + ", slotName='" + this.slotName + "', uiName='" + this.uiName + "'}";
    }

    public Object getContent() {
        return this.content;
    }
}

