/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.content;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.gregtechceu.gtceu.api.recipe.content.IContentSerializer;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.commons.lang3.math.NumberUtils;

public class SerializerDouble
implements IContentSerializer<Double> {
    public static SerializerDouble INSTANCE = new SerializerDouble();

    private SerializerDouble() {
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf, Double content) {
        buf.writeDouble(content.doubleValue());
    }

    @Override
    public Double fromNetwork(FriendlyByteBuf buf) {
        return buf.readDouble();
    }

    @Override
    public Double fromJson(JsonElement json) {
        return json.getAsDouble();
    }

    @Override
    public JsonElement toJson(Double content) {
        return new JsonPrimitive((Number)content);
    }

    @Override
    public Double of(Object o) {
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof CharSequence) {
            return NumberUtils.toDouble((String)o.toString(), (double)1.0);
        }
        return 0.0;
    }

    @Override
    public Double defaultValue() {
        return 0.0;
    }
}

