/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.content;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.gregtechceu.gtceu.api.recipe.content.IContentSerializer;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.commons.lang3.math.NumberUtils;

public class SerializerLong
implements IContentSerializer<Long> {
    public static SerializerLong INSTANCE = new SerializerLong();

    private SerializerLong() {
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf, Long content) {
        buf.m_130103_(content.longValue());
    }

    @Override
    public Long fromNetwork(FriendlyByteBuf buf) {
        return buf.m_130258_();
    }

    @Override
    public Long fromJson(JsonElement json) {
        return json.getAsLong();
    }

    @Override
    public JsonElement toJson(Long content) {
        return new JsonPrimitive((Number)content);
    }

    @Override
    public Long of(Object o) {
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof CharSequence) {
            return NumberUtils.toLong((String)o.toString(), (long)1L);
        }
        return 0L;
    }

    @Override
    public Long defaultValue() {
        return 0L;
    }
}

