/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.gregtechceu.gtceu.client.util.StaticFaceBakery;
import com.gregtechceu.gtceu.common.machine.electric.ConverterMachine;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ConverterRenderer
extends TieredHullMachineRenderer {
    private static final ResourceLocation ENERGY_IN = GTCEu.id("block/overlay/machine/overlay_energy_in");
    private static final ResourceLocation ENERGY_OUT = GTCEu.id("block/overlay/machine/overlay_energy_out");
    private static final ResourceLocation CONVERTER_NATIVE_IN = GTCEu.id("block/overlay/converter/converter_native_in");
    private static final ResourceLocation CONVERTER_NATIVE_OUT = GTCEu.id("block/overlay/converter/converter_native_out");

    public ConverterRenderer(int tier) {
        super(tier, GTCEu.id("block/machine/hull_machine"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderMachine(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, Direction modelFacing, ModelState modelState) {
        super.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
        ResourceLocation otherFaceTexture = ENERGY_IN;
        ResourceLocation frontFaceTexture = CONVERTER_NATIVE_OUT;
        if (machine instanceof ConverterMachine) {
            ConverterMachine converter = (ConverterMachine)machine;
            otherFaceTexture = converter.isFeToEu() ? CONVERTER_NATIVE_IN : otherFaceTexture;
            ResourceLocation resourceLocation = frontFaceTexture = converter.isFeToEu() ? ENERGY_OUT : frontFaceTexture;
        }
        if (side == frontFacing && modelFacing != null) {
            quads.add(StaticFaceBakery.bakeFace(modelFacing, ModelFactory.getBlockSprite((ResourceLocation)frontFaceTexture), modelState));
        } else if (side != null && modelFacing != null) {
            quads.add(StaticFaceBakery.bakeFace(modelFacing, ModelFactory.getBlockSprite((ResourceLocation)otherFaceTexture), modelState));
        }
    }

    @Override
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        super.onPrepareTextureAtlas(atlasName, register);
        if (atlasName.equals((Object)TextureAtlas.f_118259_)) {
            register.accept(CONVERTER_NATIVE_IN);
            register.accept(CONVERTER_NATIVE_OUT);
        }
    }
}

