/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.common.blockentity.KineticMachineBlockEntity;
import com.jozufozu.flywheel.backend.Backend;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.SuperByteBufferCache;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IKineticMachineRenderer
extends IRenderer {
    default public boolean isInvalid(BlockEntity te) {
        return !te.m_58898_() || te.m_58900_().m_60734_() == Blocks.f_50016_;
    }

    default public BlockState getRenderedBlockState(KineticMachineBlockEntity te) {
        return te.m_58900_();
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void render(BlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (this.isInvalid(blockEntity)) {
            return;
        }
        if (blockEntity instanceof KineticMachineBlockEntity) {
            KineticMachineBlockEntity kineticMachineBlockEntity = (KineticMachineBlockEntity)blockEntity;
            this.renderSafe(kineticMachineBlockEntity, partialTicks, stack, buffer, combinedLight, combinedOverlay);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderSafe(KineticMachineBlockEntity te, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        if (Backend.canUseInstancing((Level)te.m_58904_())) {
            return;
        }
        BlockState state = this.getRenderedBlockState(te);
        RenderType type = this.getRenderType(te, state);
        if (type != null) {
            KineticBlockEntityRenderer.renderRotatingBuffer((KineticBlockEntity)te, (SuperByteBuffer)this.getRotatedModel(te, state), (PoseStack)ms, (VertexConsumer)bufferSource.m_6299_(type), (int)light);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    default public RenderType getRenderType(KineticMachineBlockEntity te, BlockState state) {
        return ItemBlockRenderTypes.m_109282_((BlockState)state);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public SuperByteBuffer getRotatedModel(KineticMachineBlockEntity te, BlockState state) {
        return CachedBufferer.block((SuperByteBufferCache.Compartment)KineticBlockEntityRenderer.KINETIC_BLOCK, (BlockState)state);
    }
}

