/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.IKineticMachineRenderer;
import com.gregtechceu.gtceu.common.blockentity.KineticMachineBlockEntity;
import com.gregtechceu.gtceu.common.machine.kinetic.IKineticMachine;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface ISplitShaftRenderer
extends IKineticMachineRenderer {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    default public void renderSafe(KineticMachineBlockEntity te, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        if (!Backend.canUseInstancing((Level)te.m_58904_())) {
            Block block = te.m_58900_().m_60734_();
            Direction.Axis boxAxis = ((IRotate)block).getRotationAxis(te.m_58900_());
            BlockPos pos = te.m_58899_();
            float time = AnimationTickHolder.getRenderTime((LevelAccessor)te.m_58904_());
            for (Direction direction : Iterate.directions) {
                Direction.Axis axis = direction.m_122434_();
                if (boxAxis != axis) continue;
                float offset = KineticBlockEntityRenderer.getRotationOffsetForPosition((KineticBlockEntity)te, (BlockPos)pos, (Direction.Axis)axis);
                float angle = time * te.getSpeed() * 3.0f / 10.0f % 360.0f;
                float modifier = 1.0f;
                MetaMachine metaMachine = te.getMetaMachine();
                if (metaMachine instanceof IKineticMachine) {
                    IKineticMachine kineticMachine = (IKineticMachine)((Object)metaMachine);
                    modifier = kineticMachine.getRotationSpeedModifier(direction);
                }
                angle *= modifier;
                angle += offset;
                angle = angle / 180.0f * (float)Math.PI;
                SuperByteBuffer superByteBuffer = CachedBufferer.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)te.m_58900_(), (Direction)direction);
                KineticBlockEntityRenderer.kineticRotationTransform((SuperByteBuffer)superByteBuffer, (KineticBlockEntity)te, (Direction.Axis)axis, (float)angle, (int)light);
                superByteBuffer.renderInto(ms, bufferSource.m_6299_(RenderType.m_110451_()));
            }
        }
    }
}

