/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.gregtechceu.gtceu.client.util.StaticFaceBakery;
import com.gregtechceu.gtceu.common.machine.electric.TransformerMachine;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class TransformerRenderer
extends TieredHullMachineRenderer {
    public static final ResourceLocation ENERGY_IN = GTCEu.id("block/overlay/machine/overlay_energy_in");
    public static final ResourceLocation ENERGY_OUT = GTCEu.id("block/overlay/machine/overlay_energy_out");
    public static final ResourceLocation ENERGY_IN_HI = GTCEu.id("block/overlay/machine/overlay_energy_in_hi");
    public static final ResourceLocation ENERGY_OUT_HI = GTCEu.id("block/overlay/machine/overlay_energy_out_hi");
    public static final ResourceLocation ENERGY_IN_MULTI = GTCEu.id("block/overlay/machine/overlay_energy_in_multi");
    public static final ResourceLocation ENERGY_OUT_MULTI = GTCEu.id("block/overlay/machine/overlay_energy_out_multi");
    public static final ResourceLocation ENERGY_IN_ULTRA = GTCEu.id("block/overlay/machine/overlay_energy_in_ultra");
    public static final ResourceLocation ENERGY_OUT_ULTRA = GTCEu.id("block/overlay/machine/overlay_energy_out_ultra");
    private final int baseAmp;

    public TransformerRenderer(int tier, int baseAmp) {
        super(tier, GTCEu.id("block/machine/hull_machine"));
        this.baseAmp = baseAmp;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderMachine(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, Direction modelFacing, ModelState modelState) {
        super.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
        ResourceLocation otherFaceTexture = ENERGY_OUT;
        ResourceLocation frontFaceTexture = ENERGY_IN_MULTI;
        boolean isTransformUp = false;
        if (machine instanceof TransformerMachine) {
            TransformerMachine transformer = (TransformerMachine)machine;
            isTransformUp = transformer.isTransformUp();
        }
        switch (this.baseAmp) {
            case 1: {
                otherFaceTexture = isTransformUp ? ENERGY_IN : otherFaceTexture;
                frontFaceTexture = isTransformUp ? ENERGY_OUT_MULTI : frontFaceTexture;
                break;
            }
            case 2: {
                otherFaceTexture = isTransformUp ? ENERGY_IN_MULTI : ENERGY_OUT_MULTI;
                frontFaceTexture = isTransformUp ? ENERGY_OUT_HI : ENERGY_IN_HI;
                break;
            }
            default: {
                otherFaceTexture = isTransformUp ? ENERGY_IN_HI : ENERGY_OUT_HI;
                ResourceLocation resourceLocation = frontFaceTexture = isTransformUp ? ENERGY_OUT_ULTRA : ENERGY_IN_ULTRA;
            }
        }
        if (side == frontFacing && modelFacing != null) {
            quads.add(StaticFaceBakery.bakeFace(modelFacing, ModelFactory.getBlockSprite((ResourceLocation)frontFaceTexture), modelState, 2));
        } else if (side != null && modelFacing != null) {
            quads.add(StaticFaceBakery.bakeFace(modelFacing, ModelFactory.getBlockSprite((ResourceLocation)otherFaceTexture), modelState, 3));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        super.onPrepareTextureAtlas(atlasName, register);
        if (atlasName.equals((Object)TextureAtlas.f_118259_)) {
            register.accept(ENERGY_IN);
            register.accept(ENERGY_OUT);
            register.accept(ENERGY_IN_MULTI);
            register.accept(ENERGY_OUT_MULTI);
            register.accept(ENERGY_IN_HI);
            register.accept(ENERGY_OUT_HI);
            register.accept(ENERGY_IN_ULTRA);
            register.accept(ENERGY_OUT_ULTRA);
        }
    }
}

