/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.block;

import com.gregtechceu.gtceu.api.block.AppearanceBlock;
import com.gregtechceu.gtceu.api.machine.multiblock.IBatteryData;
import com.lowdragmc.lowdraglib.client.renderer.IBlockRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatteryBlock
extends AppearanceBlock
implements IBlockRendererProvider {
    private final IRenderer renderer;
    private final IBatteryData data;

    public BatteryBlock(BlockBehaviour.Properties properties, IBatteryData data, IRenderer renderer) {
        super(properties);
        this.data = data;
        this.renderer = renderer;
    }

    @Nullable
    public IRenderer getRenderer(BlockState state) {
        return this.renderer;
    }

    public IBatteryData getData() {
        return this.data;
    }

    public static enum BatteryPartType implements StringRepresentable,
    IBatteryData
    {
        EMPTY_TIER_I,
        EV_LAPOTRONIC(4, 150000000L),
        IV_LAPOTRONIC(5, 1500000000L),
        EMPTY_TIER_II,
        LuV_LAPOTRONIC(6, 6000000000L),
        ZPM_LAPOTRONIC(7, 24000000000L),
        EMPTY_TIER_III,
        UV_LAPOTRONIC(8, 96000000000L),
        UHV_ULTIMATE(9, Long.MAX_VALUE);

        private final int tier;
        private final long capacity;

        private BatteryPartType() {
            this.tier = -1;
            this.capacity = 0L;
        }

        private BatteryPartType(int tier, long capacity) {
            this.tier = tier;
            this.capacity = capacity;
        }

        @Override
        public int getTier() {
            return this.tier;
        }

        @Override
        public long getCapacity() {
            return this.capacity;
        }

        @Override
        @NotNull
        public String getBatteryName() {
            return this.name().toLowerCase();
        }

        @NotNull
        public String m_7912_() {
            return this.getBatteryName();
        }
    }
}

