/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.block;

import com.gregtechceu.gtceu.api.block.BlockProperties;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.common.blockentity.KineticMachineBlockEntity;
import com.gregtechceu.gtceu.common.machine.KineticMachineDefinition;
import com.gregtechceu.gtceu.common.machine.kinetic.IKineticMachine;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class KineticMachineBlock
extends MetaMachineBlock
implements IRotate {
    public KineticMachineBlock(BlockBehaviour.Properties properties, KineticMachineDefinition definition) {
        super(properties, definition);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)world, pos);
        if (metaMachine instanceof IKineticMachine) {
            IKineticMachine kineticMachine = (IKineticMachine)((Object)metaMachine);
            return kineticMachine.hasShaftTowards(face);
        }
        return false;
    }

    public Direction getRotationFacing(BlockState state) {
        Direction frontFacing = this.getFrontFacing(state);
        return ((KineticMachineDefinition)this.definition).isFrontRotation() ? frontFacing : (frontFacing.m_122434_() == Direction.Axis.Y ? Direction.NORTH : frontFacing.m_122427_());
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return this.getRotationFacing(state).m_122434_();
    }

    @Override
    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof KineticBlockEntity) {
            KineticBlockEntity kineticTileEntity = (KineticBlockEntity)tileEntity;
            kineticTileEntity.preventSpeedUpdate = 0;
            if (oldState.m_60734_() != state.m_60734_()) {
                return;
            }
            if (state.m_155947_() != oldState.m_155947_()) {
                return;
            }
            if (!this.areStatesKineticallyEquivalent(oldState, state)) {
                return;
            }
            kineticTileEntity.preventSpeedUpdate = 2;
        }
    }

    @Override
    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)this.rotationState.property, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)this.rotationState.property)));
    }

    public boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        if (oldState.m_60734_() != newState.m_60734_()) {
            return false;
        }
        return this.getRotationAxis(newState) == this.getRotationAxis(oldState);
    }

    public void m_7742_(BlockState stateIn, LevelAccessor worldIn, BlockPos pos, int flags, int count) {
        if (worldIn.m_5776_()) {
            return;
        }
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (!(tileEntity instanceof KineticBlockEntity)) {
            return;
        }
        KineticBlockEntity kte = (KineticBlockEntity)tileEntity;
        if (kte.preventSpeedUpdate > 0) {
            return;
        }
        kte.warnOfMovement();
        kte.clearKineticInformation();
        kte.updateSpeed = true;
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (blockEntityType == this.getDefinition().getBlockEntityType()) {
            if (!level.f_46443_) {
                return (pLevel, pPos, pState, pTile) -> {
                    if (((Boolean)pState.m_61143_((Property)BlockProperties.SERVER_TICK)).booleanValue() && pTile instanceof IMachineBlockEntity) {
                        IMachineBlockEntity metaMachine = (IMachineBlockEntity)pTile;
                        metaMachine.getMetaMachine().serverTick();
                    }
                    if (pTile instanceof KineticMachineBlockEntity) {
                        KineticMachineBlockEntity kineticMachineBlockEntity = (KineticMachineBlockEntity)pTile;
                        kineticMachineBlockEntity.tick();
                    }
                };
            }
            return (pLevel, pPos, pState, pTile) -> {
                if (pTile instanceof IMachineBlockEntity) {
                    IMachineBlockEntity metaMachine = (IMachineBlockEntity)pTile;
                    metaMachine.getMetaMachine().clientTick();
                }
                if (pTile instanceof KineticMachineBlockEntity) {
                    KineticMachineBlockEntity kineticMachineBlockEntity = (KineticMachineBlockEntity)pTile;
                    kineticMachineBlockEntity.tick();
                }
            };
        }
        return null;
    }
}

